/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.client.validation.jwt;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.jwk.source.ImmutableSecret;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.BadJWEException;
import com.nimbusds.jose.proc.BadJWSException;
import com.nimbusds.jose.proc.DefaultJOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JWEDecryptionKeySelector;
import com.nimbusds.jose.proc.JWEKeySelector;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.proc.BadJWTException;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.text.ParseException;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apereo.cas.client.authentication.AttributePrincipalImpl;
import org.apereo.cas.client.validation.Assertion;
import org.apereo.cas.client.validation.AssertionImpl;
import org.apereo.cas.client.validation.TicketValidationException;
import org.apereo.cas.client.validation.TicketValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasJWTTicketValidator
implements TicketValidator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String signingKey;
    private String encryptionKey;
    private String expectedIssuer;
    private String expectedAudience;
    private String encryptionKeyAlgorithm = "AES";
    private String signingKeyAlgorithm = "AES";
    private String requiredClaims = "sub,aud,iat,jti,exp,iss";
    private boolean base64EncryptionKey = true;
    private boolean base64SigningKey;
    private int maxClockSkew = 60;
    private ConfigurableJWTProcessor<SecurityContext> jwtProcessor;

    @Override
    public Assertion validate(String ticket, String service) throws TicketValidationException {
        try {
            if (this.jwtProcessor == null) {
                this.initialize();
            }
            JWTClaimsSet claimsSet = this.jwtProcessor.process(ticket, null);
            this.logger.debug("Validated claims are {}", (Object)claimsSet);
            return new AssertionImpl(new AttributePrincipalImpl(claimsSet.getSubject(), claimsSet.getClaims()), claimsSet.getIssueTime(), claimsSet.getExpirationTime(), claimsSet.getIssueTime(), new HashMap<String, Object>());
        }
        catch (Exception e) {
            throw new TicketValidationException(e);
        }
    }

    public void initialize() {
        this.logger.debug("Initializing JWT processor...");
        this.jwtProcessor = new CasJWTProcessor();
        this.jwtProcessor.setJWSTypeVerifier((JOSEObjectTypeVerifier)new DefaultJOSEObjectTypeVerifier(new JOSEObjectType[]{JOSEObjectType.JWT}));
        ImmutableSecret jweKeySource = new ImmutableSecret((SecretKey)new SecretKeySpec(this.base64EncryptionKey ? Base64.getDecoder().decode(this.encryptionKey) : this.encryptionKey.getBytes(StandardCharsets.UTF_8), this.encryptionKeyAlgorithm));
        ImmutableSecret jwsKeySource = new ImmutableSecret((SecretKey)new SecretKeySpec(this.base64SigningKey ? Base64.getDecoder().decode(this.signingKey) : this.signingKey.getBytes(StandardCharsets.UTF_8), this.signingKeyAlgorithm));
        CasJWTTicketValidator.configureKeySelectors(this.jwtProcessor, (ImmutableSecret<SecurityContext>)jweKeySource, (ImmutableSecret<SecurityContext>)jwsKeySource);
        Set<String> requiredClaimsSet = Set.of(this.requiredClaims.split(","));
        JWTClaimsSet exactMatchClaims = new JWTClaimsSet.Builder().issuer(this.expectedIssuer).audience(this.expectedAudience).build();
        DefaultJWTClaimsVerifier jwtClaimsSetVerifier = new DefaultJWTClaimsVerifier(exactMatchClaims, requiredClaimsSet);
        jwtClaimsSetVerifier.setMaxClockSkew(this.maxClockSkew);
        this.jwtProcessor.setJWTClaimsSetVerifier((JWTClaimsSetVerifier)jwtClaimsSetVerifier);
    }

    private static void configureKeySelectors(ConfigurableJWTProcessor<SecurityContext> jwtProcessor, final ImmutableSecret<SecurityContext> jweKeySource, final ImmutableSecret<SecurityContext> jwsKeySource) {
        JWSVerificationKeySelector<SecurityContext> jwsKeySelector = new JWSVerificationKeySelector<SecurityContext>(JWSAlgorithm.RS256, jwsKeySource){

            public List<Key> selectJWSKeys(JWSHeader jwsHeader, SecurityContext context) {
                return List.of(jwsKeySource.getSecretKey());
            }
        };
        JWEDecryptionKeySelector<SecurityContext> jweKeySelector = new JWEDecryptionKeySelector<SecurityContext>(JWEAlgorithm.DIR, EncryptionMethod.A128CBC_HS256, jweKeySource){

            public List<Key> selectJWEKeys(JWEHeader jweHeader, SecurityContext context) {
                return List.of(jweKeySource.getSecretKey());
            }
        };
        jwtProcessor.setJWSKeySelector((JWSKeySelector)jwsKeySelector);
        jwtProcessor.setJWEKeySelector((JWEKeySelector)jweKeySelector);
    }

    public void setBase64EncryptionKey(boolean base64EncryptionKey) {
        this.base64EncryptionKey = base64EncryptionKey;
    }

    public void setBase64SigningKey(boolean base64SigningKey) {
        this.base64SigningKey = base64SigningKey;
    }

    public void setRequiredClaims(String requiredClaims) {
        this.requiredClaims = requiredClaims;
    }

    public void setEncryptionKeyAlgorithm(String encryptionKeyAlgorithm) {
        this.encryptionKeyAlgorithm = encryptionKeyAlgorithm;
    }

    public void setSigningKeyAlgorithm(String signingKeyAlgorithm) {
        this.signingKeyAlgorithm = signingKeyAlgorithm;
    }

    public void setExpectedAudience(String expectedAudience) {
        this.expectedAudience = expectedAudience;
    }

    public void setExpectedIssuer(String expectedIssuer) {
        this.expectedIssuer = expectedIssuer;
    }

    public void setSigningKey(String signingKey) {
        this.signingKey = signingKey;
    }

    public void setEncryptionKey(String encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public void setMaxClockSkew(int maxClockSkew) {
        this.maxClockSkew = maxClockSkew;
    }

    private static class CasJWTProcessor
    extends DefaultJWTProcessor<SecurityContext> {
        private CasJWTProcessor() {
        }

        public JWTClaimsSet process(SignedJWT signedJWT, SecurityContext context) throws BadJOSEException, JOSEException {
            this.getJWETypeVerifier().verify(signedJWT.getHeader().getType(), context);
            List keyCandidates = this.getJWSKeySelector().selectJWSKeys(signedJWT.getHeader(), context);
            if (keyCandidates == null || keyCandidates.isEmpty()) {
                throw new BadJOSEException("Signed JWT rejected: Another algorithm expected, or no matching key(s) found");
            }
            ListIterator it = keyCandidates.listIterator();
            while (it.hasNext()) {
                JWSVerifier verifier = this.getJWSVerifierFactory().createJWSVerifier(signedJWT.getHeader(), (Key)it.next());
                if (verifier == null) continue;
                boolean validSignature = signedJWT.verify(verifier);
                if (validSignature) {
                    try {
                        if (signedJWT.getPayload() != null && signedJWT.getPayload().toJSONObject() == null) {
                            try {
                                JWT innerJwt = JWTParser.parse((String)signedJWT.getPayload().toString());
                                if (innerJwt instanceof EncryptedJWT) {
                                    EncryptedJWT encryptedJWT = (EncryptedJWT)innerJwt;
                                    return this.process(encryptedJWT, context);
                                }
                            }
                            catch (ParseException e) {
                                throw new BadJWSException("Unable to parse inner JWT", (Throwable)e);
                            }
                        }
                        JWTClaimsSet claimsSet = signedJWT.getJWTClaimsSet();
                        if (this.getJWTClaimsSetVerifier() != null) {
                            this.getJWTClaimsSetVerifier().verify(claimsSet, context);
                        }
                        return claimsSet;
                    }
                    catch (ParseException e) {
                        throw new BadJWSException("Unable to parse JWT", (Throwable)e);
                    }
                }
                if (it.hasNext()) continue;
                throw new BadJWSException("Signed JWT rejected: Invalid signature");
            }
            throw new BadJOSEException("JWS object rejected: No matching verifier(s) found");
        }

        public JWTClaimsSet process(EncryptedJWT encryptedJWT, SecurityContext context) throws BadJOSEException, JOSEException {
            this.getJWETypeVerifier().verify(encryptedJWT.getHeader().getType(), context);
            List keyCandidates = this.getJWEKeySelector().selectJWEKeys(encryptedJWT.getHeader(), context);
            if (keyCandidates == null || keyCandidates.isEmpty()) {
                throw new BadJOSEException("Encrypted JWT rejected: Another algorithm expected, or no matching key(s) found");
            }
            ListIterator it = keyCandidates.listIterator();
            while (it.hasNext()) {
                JWEDecrypter decrypter = this.getJWEDecrypterFactory().createJWEDecrypter(encryptedJWT.getHeader(), (Key)it.next());
                if (decrypter == null) continue;
                try {
                    encryptedJWT.decrypt(decrypter);
                }
                catch (JOSEException e) {
                    if (it.hasNext()) continue;
                    throw new BadJWEException("Encrypted JWT rejected: " + e.getMessage(), (Throwable)e);
                }
                if ("JWT".equalsIgnoreCase(encryptedJWT.getHeader().getContentType())) {
                    SignedJWT signedJWTPayload = encryptedJWT.getPayload().toSignedJWT();
                    if (signedJWTPayload != null) {
                        return this.process(signedJWTPayload, context);
                    }
                    if (encryptedJWT.getPayload().toJSONObject() == null) {
                        throw new BadJWTException("The payload is not a nested signed JWT");
                    }
                }
                try {
                    JWTClaimsSet claimsSet = encryptedJWT.getJWTClaimsSet();
                    if (this.getJWTClaimsSetVerifier() != null) {
                        this.getJWTClaimsSetVerifier().verify(claimsSet, context);
                    }
                    return claimsSet;
                }
                catch (ParseException e) {
                    throw new BadJWTException(e.getMessage(), (Throwable)e);
                }
            }
            throw new BadJOSEException("Encrypted JWT rejected: No matching decrypter(s) found");
        }
    }
}

