/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.SyncopeConstants;
import org.apache.syncope.common.lib.to.ConnObject;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.to.PullTaskTO;
import org.apache.syncope.common.lib.to.PushTaskTO;
import org.apache.syncope.common.lib.to.ReconStatus;
import org.apache.syncope.common.lib.types.AnyEntitlement;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.MatchType;
import org.apache.syncope.common.rest.api.beans.AbstractCSVSpec;
import org.apache.syncope.common.rest.api.beans.CSVPullSpec;
import org.apache.syncope.common.rest.api.beans.CSVPushSpec;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.ApplicationContextProvider;
import org.apache.syncope.core.persistence.api.dao.AnyDAO;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.DerSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.user.LinkedAccount;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.api.utils.RealmUtils;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.ConnectorManager;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.job.JobExecutionException;
import org.apache.syncope.core.provisioning.api.pushpull.ConstantReconFilterBuilder;
import org.apache.syncope.core.provisioning.api.pushpull.KeyValueReconFilterBuilder;
import org.apache.syncope.core.provisioning.api.pushpull.ReconFilterBuilder;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopeSinglePullExecutor;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopeSinglePushExecutor;
import org.apache.syncope.core.provisioning.api.pushpull.stream.SyncopeStreamPullExecutor;
import org.apache.syncope.core.provisioning.api.pushpull.stream.SyncopeStreamPushExecutor;
import org.apache.syncope.core.provisioning.java.pushpull.InboundMatcher;
import org.apache.syncope.core.provisioning.java.pushpull.OutboundMatcher;
import org.apache.syncope.core.provisioning.java.pushpull.SinglePullJobDelegate;
import org.apache.syncope.core.provisioning.java.pushpull.SinglePushJobDelegate;
import org.apache.syncope.core.provisioning.java.pushpull.stream.CSVStreamConnector;
import org.apache.syncope.core.provisioning.java.pushpull.stream.StreamPullJobDelegate;
import org.apache.syncope.core.provisioning.java.pushpull.stream.StreamPushJobDelegate;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.identityconnectors.framework.common.objects.SyncDeltaBuilder;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.spi.SearchResultsHandler;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class ReconciliationLogic
extends AbstractTransactionalLogic<EntityTO> {
    protected final AnyUtilsFactory anyUtilsFactory;
    protected final AnyTypeDAO anyTypeDAO;
    protected final ExternalResourceDAO resourceDAO;
    protected final RealmSearchDAO realmSearchDAO;
    protected final PlainSchemaDAO plainSchemaDAO;
    protected final DerSchemaDAO derSchemaDAO;
    protected final AnySearchDAO anySearchDAO;
    protected final MappingManager mappingManager;
    protected final InboundMatcher inboundMatcher;
    protected final OutboundMatcher outboundMatcher;
    protected final ConnectorManager connectorManager;

    public ReconciliationLogic(AnyUtilsFactory anyUtilsFactory, AnyTypeDAO anyTypeDAO, ExternalResourceDAO resourceDAO, RealmSearchDAO realmSearchDAO, PlainSchemaDAO plainSchemaDAO, DerSchemaDAO derSchemaDAO, AnySearchDAO anySearchDAO, MappingManager mappingManager, InboundMatcher inboundMatcher, OutboundMatcher outboundMatcher, ConnectorManager connectorManager) {
        this.anyUtilsFactory = anyUtilsFactory;
        this.anyTypeDAO = anyTypeDAO;
        this.resourceDAO = resourceDAO;
        this.realmSearchDAO = realmSearchDAO;
        this.plainSchemaDAO = plainSchemaDAO;
        this.derSchemaDAO = derSchemaDAO;
        this.anySearchDAO = anySearchDAO;
        this.mappingManager = mappingManager;
        this.inboundMatcher = inboundMatcher;
        this.outboundMatcher = outboundMatcher;
        this.connectorManager = connectorManager;
    }

    protected AbstractTransactionalLogic.ProvisioningInfo getProvisioningInfo(String anyTypeKey, String resourceKey) {
        AnyType anyType = (AnyType)this.anyTypeDAO.findById(anyTypeKey).orElseThrow(() -> new NotFoundException("AnyType " + anyTypeKey));
        ExternalResource resource = (ExternalResource)this.resourceDAO.findById(resourceKey).orElseThrow(() -> new NotFoundException("Resource '" + resourceKey));
        Provision provision = (Provision)resource.getProvisionByAnyType(anyType.getKey()).orElseThrow(() -> new NotFoundException("Provision for " + String.valueOf(anyType) + " on Resource '" + resourceKey + "'"));
        if (provision.getMapping() == null) {
            throw new NotFoundException("Mapping for " + String.valueOf(anyType) + " on Resource '" + resourceKey + "'");
        }
        return new AbstractTransactionalLogic.ProvisioningInfo(anyType, resource, provision);
    }

    protected ConnObject getOnSyncope(Item connObjectKeyItem, String connObjectKeyValue, Boolean suspended, Set<Attribute> attrs) {
        ConnObject connObjectTO = ConnObjectUtils.getConnObjectTO(null, attrs);
        connObjectTO.getAttrs().add(new Attr.Builder(connObjectKeyItem.getExtAttrName()).value(connObjectKeyValue).build());
        connObjectTO.getAttrs().add(new Attr.Builder(Uid.NAME).value(connObjectKeyValue).build());
        Optional.ofNullable(suspended).ifPresent(s -> {
            connObjectTO.getAttrs().removeIf(a -> OperationalAttributes.ENABLE_NAME.equals(a.getSchema()));
            connObjectTO.getAttrs().add(new Attr.Builder(OperationalAttributes.ENABLE_NAME).value(BooleanUtils.negate((Boolean)s).toString()).build());
        });
        return connObjectTO;
    }

    protected ConnObject getOnSyncope(Any any, Item connObjectKeyItem, ExternalResource resource, Provision provision) {
        Boolean bl;
        MappingManager.PreparedAttrs prepared = this.mappingManager.prepareAttrsFromAny(any, null, false, Boolean.valueOf(true), resource, provision);
        String string = prepared.connObjectLink();
        if (any instanceof User) {
            User user = (User)any;
            bl = user.isSuspended();
        } else {
            bl = null;
        }
        return this.getOnSyncope(connObjectKeyItem, string, bl, prepared.attributes());
    }

    protected ConnObject getOnSyncope(LinkedAccount account, Item connObjectKeyItem, Provision provision) {
        Set attrs = this.mappingManager.prepareAttrsFromLinkedAccount(account.getOwner(), account, null, false, provision);
        return this.getOnSyncope(connObjectKeyItem, account.getConnObjectKeyValue(), account.isSuspended(), attrs);
    }

    protected Any getAny(Provision provision, AnyTypeKind anyTypeKind, String anyKey) {
        AnyDAO dao = this.anyUtilsFactory.getInstance(anyTypeKind).dao();
        String actualKey = anyKey;
        if (!SyncopeConstants.UUID_PATTERN.matcher(anyKey).matches()) {
            Optional optional;
            if (dao instanceof UserDAO) {
                UserDAO userDAO = (UserDAO)dao;
                optional = userDAO.findKey(anyKey);
            } else if (dao instanceof GroupDAO) {
                GroupDAO groupDAO = (GroupDAO)dao;
                optional = groupDAO.findKey(anyKey);
            } else {
                optional = ((AnyObjectDAO)dao).findKey(provision.getAnyType(), anyKey);
            }
            actualKey = optional.orElse(null);
        }
        return Optional.ofNullable(dao.authFind(actualKey)).orElseThrow(() -> new NotFoundException(provision.getAnyType() + " '" + anyKey + "'"));
    }

    @PreAuthorize(value="hasRole('RESOURCE_GET_CONNOBJECT')")
    public ReconStatus status(String anyTypeKey, String resourceKey, String anyKey, Set<String> moreAttrsToGet) {
        AbstractTransactionalLogic.ProvisioningInfo info = this.getProvisioningInfo(anyTypeKey, resourceKey);
        Item connObjectKeyItem = (Item)MappingUtils.getConnObjectKeyItem((Provision)info.provision()).orElseThrow(() -> new NotFoundException("ConnObjectKey for " + info.anyType().getKey() + " on resource '" + info.resource().getKey() + "'"));
        Any any = this.getAny(info.provision(), info.anyType().getKind(), anyKey);
        ReconStatus status = new ReconStatus();
        status.setMatchType(MatchType.ANY);
        status.setAnyTypeKind(any.getType().getKind());
        status.setAnyKey(any.getKey());
        status.setRealm(any.getRealm().getFullPath());
        status.setOnSyncope(this.getOnSyncope(any, connObjectKeyItem, info.resource(), info.provision()));
        List connObjs = this.outboundMatcher.match(this.connectorManager.getConnector(info.resource()), any, info.resource(), info.provision(), Optional.of((String[])moreAttrsToGet.toArray(String[]::new)));
        if (!connObjs.isEmpty()) {
            status.setOnResource(ConnObjectUtils.getConnObjectTO((String)this.outboundMatcher.getFIQL((ConnectorObject)connObjs.getFirst(), info.resource(), info.provision()), (Set)((ConnectorObject)connObjs.getFirst()).getAttributes()));
            if (connObjs.size() > 1) {
                LOG.warn("Expected single match, found {}", (Object)connObjs);
            }
        }
        return status;
    }

    protected SyncDeltaBuilder syncDeltaBuilder(ExternalResource resource, Provision provision, Filter filter, Set<String> moreAttrsToGet) {
        OperationOptions options = MappingUtils.buildOperationOptions(provision.getMapping().getItems().stream(), (String[])((String[])moreAttrsToGet.toArray(String[]::new)));
        final SyncDeltaBuilder syncDeltaBuilder = new SyncDeltaBuilder().setToken(new SyncToken((Object)"")).setDeltaType(SyncDeltaType.CREATE_OR_UPDATE).setObjectClass(new ObjectClass(provision.getObjectClass()));
        this.connectorManager.getConnector(resource).search(syncDeltaBuilder.getObjectClass(), filter, new SearchResultsHandler(){

            public boolean handle(ConnectorObject connObj) {
                syncDeltaBuilder.setObject(connObj);
                return false;
            }

            public void handleResult(SearchResult sr) {
            }
        }, 1, null, List.of(), options);
        return syncDeltaBuilder;
    }

    @PreAuthorize(value="hasRole('RESOURCE_GET_CONNOBJECT')")
    public ReconStatus status(String anyTypeKey, String resourceKey, Filter filter, Set<String> moreAttrsToGet) {
        AbstractTransactionalLogic.ProvisioningInfo info = this.getProvisioningInfo(anyTypeKey, resourceKey);
        SyncDeltaBuilder syncDeltaBuilder = this.syncDeltaBuilder(info.resource(), info.provision(), filter, moreAttrsToGet);
        ReconStatus status = new ReconStatus();
        if (syncDeltaBuilder.getObject() != null) {
            Item connObjectKeyItem = (Item)MappingUtils.getConnObjectKeyItem((Provision)info.provision()).orElseThrow(() -> new NotFoundException("ConnObjectKey for " + info.anyType().getKey() + " on resource '" + info.resource().getKey() + "'"));
            this.inboundMatcher.match(syncDeltaBuilder.build(), info.resource(), info.provision(), info.anyType().getKind()).stream().findFirst().ifPresent(match -> {
                if (match.getAny() != null) {
                    status.setMatchType(MatchType.ANY);
                    status.setAnyTypeKind(match.getAny().getType().getKind());
                    status.setAnyKey(match.getAny().getKey());
                    status.setRealm(match.getAny().getRealm().getFullPath());
                    status.setOnSyncope(this.getOnSyncope(match.getAny(), connObjectKeyItem, info.resource(), info.provision()));
                } else if (match.getLinkedAccount() != null) {
                    status.setMatchType(MatchType.LINKED_ACCOUNT);
                    status.setAnyTypeKind(AnyTypeKind.USER);
                    status.setAnyKey(match.getLinkedAccount().getOwner().getKey());
                    status.setRealm(match.getLinkedAccount().getOwner().getRealm().getFullPath());
                    status.setOnSyncope(this.getOnSyncope(match.getLinkedAccount(), connObjectKeyItem, info.provision()));
                }
            });
            status.setOnResource(ConnObjectUtils.getConnObjectTO((String)this.outboundMatcher.getFIQL(syncDeltaBuilder.getObject(), info.resource(), info.provision()), (Set)syncDeltaBuilder.getObject().getAttributes()));
        }
        return status;
    }

    protected SyncopeSinglePushExecutor singlePushExecutor() {
        return (SyncopeSinglePushExecutor)ApplicationContextProvider.getBeanFactory().createBean(SinglePushJobDelegate.class);
    }

    @PreAuthorize(value="hasRole('TASK_EXECUTE')")
    public List<ProvisioningReport> push(String anyTypeKey, String resourceKey, String anyKey, PushTaskTO pushTask) {
        AbstractTransactionalLogic.ProvisioningInfo info = this.getProvisioningInfo(anyTypeKey, resourceKey);
        SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Reconciliation);
        ArrayList<ProvisioningReport> results = new ArrayList<ProvisioningReport>();
        try {
            results.addAll(this.singlePushExecutor().push(info.resource(), info.provision(), this.connectorManager.getConnector(info.resource()), this.getAny(info.provision(), info.anyType().getKind(), anyKey), pushTask, AuthContextUtils.getWho()));
            if (!results.isEmpty() && ((ProvisioningReport)results.getFirst()).getStatus() == ProvisioningReport.Status.FAILURE) {
                sce.getElements().add(((ProvisioningReport)results.getFirst()).getMessage());
            }
        }
        catch (JobExecutionException e) {
            sce.getElements().add(e.getMessage());
        }
        if (!sce.isEmpty()) {
            throw sce;
        }
        return results;
    }

    @PreAuthorize(value="hasRole('TASK_EXECUTE')")
    public List<ProvisioningReport> push(String anyTypeKey, String resourceKey, Filter filter, Set<String> moreAttrsToGet, PushTaskTO pushTask) {
        AbstractTransactionalLogic.ProvisioningInfo info = this.getProvisioningInfo(anyTypeKey, resourceKey);
        SyncDeltaBuilder syncDeltaBuilder = this.syncDeltaBuilder(info.resource(), info.provision(), filter, moreAttrsToGet);
        SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Reconciliation);
        ArrayList<ProvisioningReport> results = new ArrayList<ProvisioningReport>();
        if (syncDeltaBuilder.getObject() != null) {
            this.inboundMatcher.match(syncDeltaBuilder.build(), info.resource(), info.provision(), info.anyType().getKind()).stream().findFirst().ifPresent(match -> {
                try {
                    if (match.getMatchTarget() == MatchType.ANY) {
                        results.addAll(this.singlePushExecutor().push(info.resource(), info.provision(), this.connectorManager.getConnector(info.resource()), match.getAny(), pushTask, AuthContextUtils.getWho()));
                        if (!results.isEmpty() && ((ProvisioningReport)results.getFirst()).getStatus() == ProvisioningReport.Status.FAILURE) {
                            sce.getElements().add(((ProvisioningReport)results.getFirst()).getMessage());
                        }
                    } else {
                        ProvisioningReport result = this.singlePushExecutor().push(info.resource(), info.provision(), this.connectorManager.getConnector(info.resource()), match.getLinkedAccount(), pushTask, AuthContextUtils.getWho());
                        if (result.getStatus() == ProvisioningReport.Status.FAILURE) {
                            sce.getElements().add(result.getMessage());
                        } else {
                            results.add(result);
                        }
                    }
                }
                catch (JobExecutionException e) {
                    sce.getElements().add(e.getMessage());
                }
            });
        }
        if (!sce.isEmpty()) {
            throw sce;
        }
        return results;
    }

    protected List<ProvisioningReport> pull(ExternalResource resource, Provision provision, ReconFilterBuilder reconFilterBuilder, Set<String> moreAttrsToGet, PullTaskTO pullTask) {
        if (pullTask.getDestinationRealm() == null || this.realmSearchDAO.findByFullPath(pullTask.getDestinationRealm()) == null) {
            throw new NotFoundException("Realm " + pullTask.getDestinationRealm());
        }
        SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Reconciliation);
        ArrayList<ProvisioningReport> results = new ArrayList<ProvisioningReport>();
        try {
            SyncopeSinglePullExecutor executor = (SyncopeSinglePullExecutor)ApplicationContextProvider.getBeanFactory().createBean(SinglePullJobDelegate.class);
            results.addAll(executor.pull(resource, provision, this.connectorManager.getConnector(resource), reconFilterBuilder, moreAttrsToGet, pullTask, AuthContextUtils.getWho()));
            if (!results.isEmpty() && ((ProvisioningReport)results.getFirst()).getStatus() == ProvisioningReport.Status.FAILURE) {
                sce.getElements().add(((ProvisioningReport)results.getFirst()).getMessage());
            }
        }
        catch (JobExecutionException e) {
            sce.getElements().add(e.getMessage());
        }
        if (!sce.isEmpty()) {
            throw sce;
        }
        return results;
    }

    @PreAuthorize(value="hasRole('TASK_EXECUTE')")
    @Transactional(noRollbackFor={SyncopeClientException.class})
    public List<ProvisioningReport> pull(String anyTypeKey, String resourceKey, String anyKey, Set<String> moreAttrsToGet, PullTaskTO pullTask) {
        AbstractTransactionalLogic.ProvisioningInfo info = this.getProvisioningInfo(anyTypeKey, resourceKey);
        if (info.provision().getMapping().getConnObjectKeyItem().isEmpty()) {
            throw new NotFoundException("ConnObjectKey cannot be determined for mapping " + anyTypeKey);
        }
        Any any = this.getAny(info.provision(), info.anyType().getKind(), anyKey);
        String connObjectKeyValue = (String)this.mappingManager.getConnObjectKeyValue(any, info.resource(), info.provision()).orElseThrow(() -> new NotFoundException("ConnObjectKey for " + info.anyType().getKey() + " on resource '" + info.resource().getKey() + "'"));
        return this.pull(info.resource(), info.provision(), (ReconFilterBuilder)new KeyValueReconFilterBuilder(((Item)info.provision().getMapping().getConnObjectKeyItem().get()).getExtAttrName(), connObjectKeyValue), moreAttrsToGet, pullTask);
    }

    @PreAuthorize(value="hasRole('TASK_EXECUTE')")
    @Transactional(noRollbackFor={SyncopeClientException.class})
    public List<ProvisioningReport> pull(String anyTypeKey, String resourceKey, Filter filter, Set<String> moreAttrsToGet, PullTaskTO pullTask) {
        AbstractTransactionalLogic.ProvisioningInfo info = this.getProvisioningInfo(anyTypeKey, resourceKey);
        return this.pull(info.resource(), info.provision(), (ReconFilterBuilder)new ConstantReconFilterBuilder(filter), moreAttrsToGet, pullTask);
    }

    protected CsvSchema.Builder csvSchema(AbstractCSVSpec spec) {
        CsvSchema.Builder schemaBuilder = new CsvSchema.Builder().setUseHeader(true).setColumnSeparator(spec.getColumnSeparator()).setArrayElementSeparator(spec.getArrayElementSeparator()).setQuoteChar(spec.getQuoteChar()).setLineSeparator(spec.getLineSeparator()).setNullValue(spec.getNullValue()).setAllowComments(spec.getAllowComments().booleanValue());
        if (spec.getEscapeChar() != null) {
            schemaBuilder.setEscapeChar(spec.getEscapeChar().charValue());
        }
        return schemaBuilder;
    }

    @PreAuthorize(value="hasRole('TASK_EXECUTE')")
    public List<ProvisioningReport> push(SearchCond searchCond, Pageable pageable, String realm, CSVPushSpec spec, OutputStream os) {
        List list;
        List matching;
        SearchCond effectiveCond;
        AnyType anyType = (AnyType)this.anyTypeDAO.findById(spec.getAnyTypeKey()).orElseThrow(() -> new NotFoundException("AnyType " + spec.getAnyTypeKey()));
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(anyType.getKind());
        String entitlement = switch (anyType.getKind()) {
            case AnyTypeKind.GROUP -> "GROUP_SEARCH";
            case AnyTypeKind.ANY_OBJECT -> AnyEntitlement.SEARCH.getFor(anyType.getKey());
            default -> "USER_SEARCH";
        };
        Realm base = (Realm)this.realmSearchDAO.findByFullPath(realm).orElseThrow(() -> new NotFoundException("Realm " + realm));
        Set adminRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get(entitlement)), (String)realm);
        SearchCond searchCond2 = effectiveCond = searchCond == null ? anyUtils.dao().getAllMatchingCond() : searchCond;
        if (spec.getIgnorePaging().booleanValue()) {
            matching = new ArrayList();
            long count = this.anySearchDAO.count(base, true, adminRealms, effectiveCond, anyType.getKind());
            long pages = count / 500L + 1L;
            int page = 0;
            while ((long)page < pages) {
                matching.addAll(this.anySearchDAO.search(base, true, adminRealms, effectiveCond, (Pageable)PageRequest.of((int)page, (int)500, (Sort)pageable.getSort()), anyType.getKind()));
                ++page;
            }
        } else {
            matching = this.anySearchDAO.search(base, true, adminRealms, effectiveCond, pageable, anyType.getKind());
        }
        ArrayList columns = new ArrayList();
        spec.getFields().forEach(item -> anyUtils.getField(item).ifPresentOrElse(field -> columns.add(item), () -> LOG.warn("Ignoring invalid field {}", item)));
        spec.getPlainAttrs().forEach(item -> {
            if (this.plainSchemaDAO.existsById(item)) {
                columns.add(item);
            } else {
                LOG.warn("Ignoring invalid plain schema {}", item);
            }
        });
        spec.getDerAttrs().forEach(item -> {
            if (this.derSchemaDAO.existsById(item)) {
                columns.add(item);
            } else {
                LOG.warn("Ignoring invalid derived schema {}", item);
            }
        });
        PushTaskTO pushTask = new PushTaskTO();
        pushTask.setMatchingRule(spec.getMatchingRule());
        pushTask.setUnmatchingRule(spec.getUnmatchingRule());
        pushTask.getActions().addAll(spec.getProvisioningActions());
        CSVStreamConnector connector = new CSVStreamConnector(null, spec.getArrayElementSeparator(), this.csvSchema((AbstractCSVSpec)spec), null, os, (String[])columns.toArray(String[]::new));
        try {
            SyncopeStreamPushExecutor executor = (SyncopeStreamPushExecutor)ApplicationContextProvider.getBeanFactory().createBean(StreamPushJobDelegate.class);
            list = executor.push(anyType, matching, columns, (Connector)connector, spec.getPropagationActions(), pushTask, AuthContextUtils.getWho());
        }
        catch (Throwable executor) {
            try {
                try {
                    connector.close();
                }
                catch (Throwable throwable) {
                    executor.addSuppressed(throwable);
                }
                throw executor;
            }
            catch (Exception e) {
                LOG.error("Could not push to stream", (Throwable)e);
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Reconciliation);
                sce.getElements().add(e.getMessage());
                throw sce;
            }
        }
        connector.close();
        return list;
    }

    @PreAuthorize(value="hasRole('TASK_EXECUTE')")
    @Transactional(noRollbackFor={SyncopeClientException.class})
    public List<ProvisioningReport> pull(CSVPullSpec spec, InputStream csv) {
        List list;
        AnyType anyType = (AnyType)this.anyTypeDAO.findById(spec.getAnyTypeKey()).orElseThrow(() -> new NotFoundException("AnyType " + spec.getAnyTypeKey()));
        if (this.realmSearchDAO.findByFullPath(spec.getDestinationRealm()) == null) {
            throw new NotFoundException("Realm " + spec.getDestinationRealm());
        }
        PullTaskTO pullTask = new PullTaskTO();
        pullTask.setDestinationRealm(spec.getDestinationRealm());
        pullTask.setRemediation(spec.getRemediation().booleanValue());
        pullTask.setMatchingRule(spec.getMatchingRule());
        pullTask.setUnmatchingRule(spec.getUnmatchingRule());
        pullTask.getActions().addAll(spec.getProvisioningActions());
        CSVStreamConnector connector = new CSVStreamConnector(spec.getKeyColumn(), spec.getArrayElementSeparator(), this.csvSchema((AbstractCSVSpec)spec), csv, null, new String[0]);
        try {
            List columns = connector.getColumns(spec);
            if (!columns.contains(spec.getKeyColumn())) {
                throw new NotFoundException("Key column '" + spec.getKeyColumn() + "'");
            }
            SyncopeStreamPullExecutor executor = (SyncopeStreamPullExecutor)ApplicationContextProvider.getBeanFactory().createBean(StreamPullJobDelegate.class);
            list = executor.pull(anyType, spec.getKeyColumn(), columns, spec.getConflictResolutionAction(), spec.getInboundCorrelationRule(), (Connector)connector, pullTask, AuthContextUtils.getWho());
        }
        catch (Throwable columns) {
            try {
                try {
                    connector.close();
                }
                catch (Throwable throwable) {
                    columns.addSuppressed(throwable);
                }
                throw columns;
            }
            catch (NotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error("Could not pull from stream", (Throwable)e);
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Reconciliation);
                sce.getElements().add(e.getMessage());
                throw sce;
            }
        }
        connector.close();
        return list;
    }

    protected EntityTO resolveReference(Method method, Object ... os) throws UnresolvedReferenceException {
        throw new UnresolvedReferenceException();
    }
}

