/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.common.content;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class MultiParentNode {
    private final String object;
    private final Set<MultiParentNode> children = new HashSet<MultiParentNode>();
    private boolean exploited = false;

    public MultiParentNode(String object) {
        this.object = object;
    }

    public String getObject() {
        return this.object;
    }

    public boolean isParent(MultiParentNode child) {
        return this.children.contains(child);
    }

    public boolean isChild(MultiParentNode parent) {
        return parent.isParent(this);
    }

    public Set<MultiParentNode> getChildren() {
        return this.children;
    }

    public void addParent(MultiParentNode parent) {
        if (parent != null) {
            parent.children.add(this);
        }
    }

    public void removeParent(MultiParentNode parent) {
        if (parent != null) {
            parent.children.remove(this);
        }
    }

    public void addChild(MultiParentNode child) {
        if (child != null) {
            this.children.add(child);
        }
    }

    public void removeChild(MultiParentNode child) {
        if (child != null) {
            this.children.remove(child);
        }
    }

    public boolean isExploited() {
        return this.exploited;
    }

    public void setExploited(boolean exploited) {
        this.exploited = exploited;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.object).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiParentNode other = (MultiParentNode)obj;
        return new EqualsBuilder().append((Object)this.object, (Object)other.object).build();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.object).build();
    }
}

