/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.client.validation;

import jakarta.servlet.FilterConfig;
import org.apereo.cas.client.Protocol;
import org.apereo.cas.client.configuration.ConfigurationKeys;
import org.apereo.cas.client.ssl.HttpURLConnectionFactory;
import org.apereo.cas.client.ssl.HttpsURLConnectionFactory;
import org.apereo.cas.client.validation.AbstractTicketValidationFilter;
import org.apereo.cas.client.validation.Saml11TicketValidator;
import org.apereo.cas.client.validation.TicketValidator;

public class Saml11TicketValidationFilter
extends AbstractTicketValidationFilter {
    public Saml11TicketValidationFilter() {
        super(Protocol.SAML11);
    }

    protected final TicketValidator getTicketValidator(FilterConfig filterConfig) {
        Saml11TicketValidator validator = new Saml11TicketValidator(this.getString(ConfigurationKeys.CAS_SERVER_URL_PREFIX));
        long tolerance = this.getLong(ConfigurationKeys.TOLERANCE);
        validator.setTolerance(tolerance);
        validator.setRenew(this.getBoolean(ConfigurationKeys.RENEW));
        HttpsURLConnectionFactory factory = new HttpsURLConnectionFactory(this.getHostnameVerifier(), this.getSSLConfig());
        validator.setURLConnectionFactory((HttpURLConnectionFactory)factory);
        validator.setEncoding(this.getString(ConfigurationKeys.ENCODING));
        return validator;
    }
}

