/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.server;

import java.io.IOException;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.server.OncRpcServerAuthScheme;
import org.acplt.oncrpc.server.OncRpcServerAuthSchemes;
import org.acplt.oncrpc.server.OncRpcServerTransport;
import org.acplt.oncrpc.server.OncRpcServerTransportRegistrationInfo;

public abstract class OncRpcServerStub {
    public OncRpcServerTransport[] transports;
    public OncRpcServerTransportRegistrationInfo[] info;
    protected Object shutdownSignal = new Object();
    private String characterEncoding;
    private final OncRpcServerAuthSchemes authenticationSchemes = new OncRpcServerAuthSchemes();

    public void run() throws OncRpcException, IOException {
        try {
            this.unregister(this.transports);
        }
        catch (OncRpcException oncRpcException) {
            // empty catch block
        }
        this.register(this.transports);
        this.run(this.transports);
        try {
            this.unregister(this.transports);
        }
        finally {
            this.close(this.transports);
        }
    }

    public void register(OncRpcServerTransport[] transports) throws OncRpcException {
        int size = transports.length;
        for (int idx = 0; idx < size; ++idx) {
            transports[idx].register();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(OncRpcServerTransport[] transports) {
        int size = transports.length;
        for (int idx = 0; idx < size; ++idx) {
            transports[idx].setAuthenticationSchemes(this.authenticationSchemes);
            transports[idx].listen();
        }
        while (true) {
            Object object = this.shutdownSignal;
            synchronized (object) {
                try {
                    this.shutdownSignal.wait();
                    break;
                }
                catch (InterruptedException e) {
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRpcProcessing() {
        if (this.shutdownSignal != null) {
            Object object = this.shutdownSignal;
            synchronized (object) {
                this.shutdownSignal.notify();
            }
        }
    }

    public void unregister(OncRpcServerTransport[] transports) throws OncRpcException {
        int size = transports.length;
        for (int idx = 0; idx < size; ++idx) {
            transports[idx].unregister();
        }
    }

    public void close(OncRpcServerTransport[] transports) {
        int size = transports.length;
        for (int idx = 0; idx < size; ++idx) {
            transports[idx].close();
        }
    }

    public boolean registerAuthenticationScheme(OncRpcServerAuthScheme authenticationScheme) {
        return this.authenticationSchemes.registerScheme(authenticationScheme);
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
        int size = this.transports.length;
        for (int idx = 0; idx < size; ++idx) {
            this.transports[idx].setCharacterEncoding(characterEncoding);
        }
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }
}

