/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration;

import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindingPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;

public class CasConfigurationPropertiesEnvironmentManager {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasConfigurationPropertiesEnvironmentManager.class);
    public static final String BEAN_NAME = "configurationPropertiesEnvironmentManager";
    private final ConfigurationPropertiesBindingPostProcessor binder;

    public static ApplicationContext rebindCasConfigurationProperties(ConfigurationPropertiesBindingPostProcessor binder, ApplicationContext applicationContext) {
        CasConfigurationProperties config = (CasConfigurationProperties)applicationContext.getBean(CasConfigurationProperties.class);
        String name = String.format("%s-%s", "cas", config.getClass().getName());
        binder.postProcessBeforeInitialization((Object)config, name);
        Object bean = applicationContext.getAutowireCapableBeanFactory().initializeBean((Object)config, name);
        applicationContext.getAutowireCapableBeanFactory().autowireBean(bean);
        LOGGER.debug("Reloaded CAS configuration [{}]", (Object)name);
        return applicationContext;
    }

    public ApplicationContext rebindCasConfigurationProperties(ApplicationContext applicationContext) {
        return CasConfigurationPropertiesEnvironmentManager.rebindCasConfigurationProperties(this.binder, applicationContext);
    }

    public static CompositePropertySource configureEnvironmentPropertySources(ConfigurableEnvironment environment) {
        CompositePropertySource nativePropertySources = new CompositePropertySource("casNativeCompositeSource");
        MutablePropertySources propertySources = environment.getPropertySources();
        FunctionUtils.doIfNotNull((Object)propertySources.get("commandLineArgs"), arg_0 -> ((CompositePropertySource)nativePropertySources).addFirstPropertySource(arg_0));
        FunctionUtils.doIfNotNull((Object)propertySources.get("systemProperties"), arg_0 -> ((CompositePropertySource)nativePropertySources).addPropertySource(arg_0));
        FunctionUtils.doIfNotNull((Object)propertySources.get("systemEnvironment"), arg_0 -> ((CompositePropertySource)nativePropertySources).addPropertySource(arg_0));
        return nativePropertySources;
    }

    @Generated
    public CasConfigurationPropertiesEnvironmentManager(ConfigurationPropertiesBindingPostProcessor binder) {
        this.binder = binder;
    }
}

