/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.beans;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.QueryParam;
import java.util.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.syncope.common.rest.api.beans.AbstractQuery;

public class AnyQuery
extends AbstractQuery {
    private static final long serialVersionUID = -6736562952418964707L;
    private String realm;
    private Boolean recursive;
    private Boolean details;
    private String fiql;

    @Parameter(name="realm", description="realms define a hierarchical security domain tree, primarily meant for containing Users, Groups and Any Objects", schema=@Schema(implementation=String.class, defaultValue="/", externalDocs=@ExternalDocumentation(description="Apache Syncope Reference Guide", url="https://syncope.apache.org/docs/3.0/reference-guide.html#realms")))
    public String getRealm() {
        return this.realm;
    }

    @DefaultValue(value="/")
    @QueryParam(value="realm")
    public void setRealm(String realm) {
        this.realm = realm;
    }

    @Parameter(name="recursive", description="whether search results shall be returned from given realm and all children realms, or just the given realm", schema=@Schema(implementation=Boolean.class))
    public Boolean getRecursive() {
        return Optional.ofNullable(this.recursive).orElse(Boolean.TRUE);
    }

    @QueryParam(value="recursive")
    @DefaultValue(value="true")
    public void setRecursive(Boolean recursive) {
        this.recursive = recursive;
    }

    @Parameter(name="details", description="whether detailed information is to be included, if applicable, about (dynamic) roles, relationships, (dynamic) memberships or linked accounts", schema=@Schema(implementation=Boolean.class))
    public Boolean getDetails() {
        return Optional.ofNullable(this.details).orElse(Boolean.TRUE);
    }

    @QueryParam(value="details")
    @DefaultValue(value="true")
    public void setDetails(Boolean details) {
        this.details = details;
    }

    public String getFiql() {
        return this.fiql;
    }

    @Parameter(name="fiql", description="Feed Item Query Language (FIQL, pronounced \u201cfickle\u201d) is a simple but flexible, URI-friendly syntax for expressing filters across the entries in a syndicated feed.", example="username==rossini", schema=@Schema(implementation=String.class, externalDocs=@ExternalDocumentation(description="Apache Syncope Reference Guide", url="https://syncope.apache.org/docs/3.0/reference-guide.html#search")))
    @QueryParam(value="fiql")
    public void setFiql(String fiql) {
        this.fiql = fiql;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnyQuery other = (AnyQuery)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.realm, (Object)other.realm).append((Object)this.details, (Object)other.details).append((Object)this.fiql, (Object)other.fiql).build();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.realm).append((Object)this.details).append((Object)this.fiql).build();
    }

    public static class Builder
    extends AbstractQuery.Builder<AnyQuery, Builder> {
        @Override
        protected AnyQuery newInstance() {
            return new AnyQuery();
        }

        public Builder recursive(boolean recursive) {
            ((AnyQuery)this.getInstance()).setRecursive(recursive);
            return this;
        }

        public Builder details(boolean details) {
            ((AnyQuery)this.getInstance()).setDetails(details);
            return this;
        }

        public Builder realm(String realm) {
            ((AnyQuery)this.getInstance()).setRealm(realm);
            return this;
        }

        public Builder fiql(String fiql) {
            ((AnyQuery)this.getInstance()).setFiql(fiql);
            return this;
        }
    }
}

