/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.converter.BaseBpmnXMLConverter;
import org.flowable.bpmn.converter.child.BaseChildElementParser;
import org.flowable.bpmn.converter.child.InParameterParser;
import org.flowable.bpmn.converter.child.OutParameterParser;
import org.flowable.bpmn.converter.export.MapExceptionExport;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.CallActivity;
import org.flowable.bpmn.model.ExtensionAttribute;

public class CallActivityXMLConverter
extends BaseBpmnXMLConverter {
    protected Map<String, BaseChildElementParser> childParserMap = new HashMap<String, BaseChildElementParser>();
    protected static final List<ExtensionAttribute> defaultCallActivityAttributes = Arrays.asList(new ExtensionAttribute("calledElement"), new ExtensionAttribute("calledElementType"), new ExtensionAttribute("completeAsync"), new ExtensionAttribute("inheritVariables"), new ExtensionAttribute("processInstanceName"), new ExtensionAttribute("useLocalScopeForOutParameters"), new ExtensionAttribute("businessKey"), new ExtensionAttribute("inheritBusinessKey"), new ExtensionAttribute("sameDeployment"), new ExtensionAttribute("fallbackToDefaultTenant"), new ExtensionAttribute("idVariableName"));

    public CallActivityXMLConverter() {
        InParameterParser inParameterParser = new InParameterParser();
        this.childParserMap.put(inParameterParser.getElementName(), inParameterParser);
        OutParameterParser outParameterParser = new OutParameterParser();
        this.childParserMap.put(outParameterParser.getElementName(), outParameterParser);
    }

    @Override
    public Class<? extends BaseElement> getBpmnElementType() {
        return CallActivity.class;
    }

    @Override
    protected String getXMLElementName() {
        return "callActivity";
    }

    @Override
    protected BaseElement convertXMLToElement(XMLStreamReader xtr, BpmnModel model) throws Exception {
        String idVariableName;
        CallActivity callActivity = new CallActivity();
        BpmnXMLUtil.addXMLLocation((BaseElement)callActivity, xtr);
        callActivity.setCalledElement(xtr.getAttributeValue(null, "calledElement"));
        callActivity.setCalledElementType(BpmnXMLUtil.getAttributeValue("calledElementType", xtr));
        callActivity.setProcessInstanceName(BpmnXMLUtil.getAttributeValue("processInstanceName", xtr));
        callActivity.setBusinessKey(BpmnXMLUtil.getAttributeValue("businessKey", xtr));
        callActivity.setInheritBusinessKey(Boolean.parseBoolean(BpmnXMLUtil.getAttributeValue("inheritBusinessKey", xtr)));
        callActivity.setInheritVariables(Boolean.valueOf(BpmnXMLUtil.getAttributeValue("inheritVariables", xtr)).booleanValue());
        callActivity.setSameDeployment(this.parseSameDeployment(xtr));
        callActivity.setUseLocalScopeForOutParameters(Boolean.valueOf(BpmnXMLUtil.getAttributeValue("useLocalScopeForOutParameters", xtr)).booleanValue());
        callActivity.setCompleteAsync(Boolean.valueOf(BpmnXMLUtil.getAttributeValue("completeAsync", xtr)).booleanValue());
        String fallbackToDefaultTenant = BpmnXMLUtil.getAttributeValue("fallbackToDefaultTenant", xtr);
        if (StringUtils.isNotEmpty((CharSequence)fallbackToDefaultTenant)) {
            callActivity.setFallbackToDefaultTenant(Boolean.valueOf(fallbackToDefaultTenant));
        }
        if (StringUtils.isNotEmpty((CharSequence)(idVariableName = BpmnXMLUtil.getAttributeValue("idVariableName", xtr)))) {
            callActivity.setProcessInstanceIdVariableName(idVariableName);
        }
        BpmnXMLUtil.addCustomAttributes(xtr, (BaseElement)callActivity, defaultElementAttributes, defaultActivityAttributes, defaultCallActivityAttributes);
        this.parseChildElements(this.getXMLElementName(), (BaseElement)callActivity, this.childParserMap, model, xtr);
        return callActivity;
    }

    protected boolean parseSameDeployment(XMLStreamReader xtr) {
        String sameDeploymentString = BpmnXMLUtil.getAttributeValue("sameDeployment", xtr);
        if (StringUtils.isNotEmpty((CharSequence)sameDeploymentString)) {
            return Boolean.valueOf(sameDeploymentString);
        }
        String calledElementBindingString = BpmnXMLUtil.getAttributeValue("calledElementBinding", xtr);
        return StringUtils.isNotEmpty((CharSequence)calledElementBindingString) && "deployment".equalsIgnoreCase(calledElementBindingString);
    }

    @Override
    protected void writeAdditionalAttributes(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        CallActivity callActivity = (CallActivity)element;
        if (StringUtils.isNotEmpty((CharSequence)callActivity.getCalledElement())) {
            xtw.writeAttribute("calledElement", callActivity.getCalledElement());
        }
        if (StringUtils.isNotEmpty((CharSequence)callActivity.getCalledElementType())) {
            this.writeQualifiedAttribute("calledElementType", callActivity.getCalledElementType(), xtw);
        }
        if (StringUtils.isNotEmpty((CharSequence)callActivity.getProcessInstanceName())) {
            this.writeQualifiedAttribute("processInstanceName", callActivity.getProcessInstanceName(), xtw);
        }
        if (StringUtils.isNotEmpty((CharSequence)callActivity.getBusinessKey())) {
            this.writeQualifiedAttribute("businessKey", callActivity.getBusinessKey(), xtw);
        }
        if (callActivity.isInheritBusinessKey()) {
            this.writeQualifiedAttribute("inheritBusinessKey", "true", xtw);
        }
        if (callActivity.isUseLocalScopeForOutParameters()) {
            this.writeQualifiedAttribute("useLocalScopeForOutParameters", "true", xtw);
        }
        if (callActivity.isInheritVariables()) {
            this.writeQualifiedAttribute("inheritVariables", "true", xtw);
        }
        if (callActivity.isSameDeployment()) {
            this.writeQualifiedAttribute("sameDeployment", "true", xtw);
        }
        if (callActivity.isCompleteAsync()) {
            this.writeQualifiedAttribute("completeAsync", "true", xtw);
        }
        if (callActivity.getFallbackToDefaultTenant() != null) {
            this.writeQualifiedAttribute("fallbackToDefaultTenant", callActivity.getFallbackToDefaultTenant().toString(), xtw);
        }
        if (callActivity.getProcessInstanceIdVariableName() != null) {
            this.writeQualifiedAttribute("idVariableName", callActivity.getProcessInstanceIdVariableName(), xtw);
        }
        BpmnXMLUtil.writeCustomAttributes(callActivity.getAttributes().values(), xtw, defaultElementAttributes, defaultActivityAttributes, defaultCallActivityAttributes);
    }

    @Override
    protected boolean writeExtensionChildElements(BaseElement element, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        CallActivity callActivity = (CallActivity)element;
        didWriteExtensionStartElement = BpmnXMLUtil.writeIOParameters("in", callActivity.getInParameters(), didWriteExtensionStartElement, xtw);
        didWriteExtensionStartElement = BpmnXMLUtil.writeIOParameters("out", callActivity.getOutParameters(), didWriteExtensionStartElement, xtw);
        didWriteExtensionStartElement = MapExceptionExport.writeMapExceptionExtensions(callActivity.getMapExceptions(), didWriteExtensionStartElement, xtw);
        return didWriteExtensionStartElement;
    }

    @Override
    protected void writeAdditionalChildElements(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
    }
}

