/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.tasks;

import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.syncope.client.console.rest.TaskRestClient;
import org.apache.syncope.client.console.wizards.BaseAjaxWizardBuilder;
import org.apache.syncope.client.ui.commons.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDateTimeFieldPanel;
import org.apache.syncope.client.ui.commons.panels.SyncopeFormPanel;
import org.apache.syncope.common.lib.SyncopeConstants;
import org.apache.syncope.common.lib.form.SyncopeForm;
import org.apache.syncope.common.lib.to.MacroTaskTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class MacroTaskExecWizardBuilder
extends BaseAjaxWizardBuilder<MacroTaskTO> {
    private static final long serialVersionUID = 3318576575286024205L;
    protected final TaskRestClient taskRestClient;
    protected final IModel<SyncopeForm> formModel = Model.of();
    protected final Model<Date> startAtDateModel = new Model();
    protected final Model<Boolean> dryRunModel = new Model((Serializable)Boolean.valueOf(false));

    public MacroTaskExecWizardBuilder(MacroTaskTO defaultItem, TaskRestClient taskRestClient, PageReference pageRef) {
        super(defaultItem, pageRef);
        this.taskRestClient = taskRestClient;
    }

    protected Serializable onApplyInternal(MacroTaskTO modelObject) {
        if (this.formModel.getObject() == null) {
            this.taskRestClient.startExecution(modelObject.getKey(), (Date)this.startAtDateModel.getObject(), (Boolean)this.dryRunModel.getObject());
        } else {
            this.taskRestClient.startExecution(modelObject.getKey(), (Date)this.startAtDateModel.getObject(), (Boolean)this.dryRunModel.getObject(), (SyncopeForm)this.formModel.getObject());
        }
        return null;
    }

    protected WizardModel buildModelSteps(MacroTaskTO modelObject, WizardModel wizardModel) {
        if (!modelObject.getFormPropertyDefs().isEmpty()) {
            this.formModel.setObject((Object)this.taskRestClient.getMacroTaskForm(modelObject.getKey()));
            wizardModel.add((IWizardStep)new Form());
        }
        wizardModel.add((IWizardStep)new StartAt());
        return wizardModel;
    }

    protected class Form
    extends WizardStep {
        private static final long serialVersionUID = 7352192594863229013L;

        protected Form() {
            this.add(new Component[]{new SyncopeFormPanel("form", (SyncopeForm)MacroTaskExecWizardBuilder.this.formModel.getObject())});
        }
    }

    protected class StartAt
    extends WizardStep {
        private static final long serialVersionUID = -961082324376783538L;

        protected StartAt() {
            final AjaxDateTimeFieldPanel startAtDate = new AjaxDateTimeFieldPanel("startAtDate", "startAtDate", MacroTaskExecWizardBuilder.this.startAtDateModel, FastDateFormat.getInstance((String)SyncopeConstants.DATE_PATTERNS[3]));
            this.add(new Component[]{startAtDate.setReadOnly(true).hideLabel()});
            final AjaxCheckBoxPanel startAtCheck = new AjaxCheckBoxPanel("startAtCheck", "startAtCheck", (IModel)new Model((Serializable)Boolean.valueOf(false)), false);
            startAtCheck.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                private static final long serialVersionUID = -1107858522700306810L;

                protected void onUpdate(AjaxRequestTarget target) {
                    target.add(new Component[]{startAtDate.setModelObject(null).setReadOnly((Boolean)startAtCheck.getModelObject() == false)});
                }
            }});
            this.add(new Component[]{startAtCheck});
            this.add(new Component[]{new AjaxCheckBoxPanel("dryRun", "dryRun", MacroTaskExecWizardBuilder.this.dryRunModel, false)});
        }
    }
}

