/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallableWorker<T> {
    private static final int DEFAULT_NUM_THREADS = Runtime.getRuntime().availableProcessors() * 2;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ExecutorService executorService;

    public CallableWorker(String poolName) {
        this(poolName, DEFAULT_NUM_THREADS);
    }

    public CallableWorker(String poolName, int numThreads) {
        this.executorService = Executors.newFixedThreadPool(numThreads, r -> {
            Thread t = new Thread(r, "ldaptive-" + poolName + "@" + this.hashCode());
            t.setDaemon(true);
            return t;
        });
    }

    public CallableWorker(ExecutorService es) {
        this.executorService = es;
    }

    public List<ExecutionException> execute(Callable<T> callable, int count, Consumer<T> consumer) {
        return this.execute(IntStream.range(0, count).mapToObj(i -> callable).collect(Collectors.toList()), consumer);
    }

    public List<ExecutionException> execute(List<Callable<T>> callables, Consumer<T> consumer) {
        ExecutorCompletionService cs = new ExecutorCompletionService(this.executorService);
        callables.forEach(cs::submit);
        ArrayList<ExecutionException> exceptions = new ArrayList<ExecutionException>(callables.size());
        for (int i = 0; i < callables.size(); ++i) {
            try {
                Object result = cs.take().get();
                consumer.accept(result);
                continue;
            }
            catch (ExecutionException e) {
                exceptions.add(e);
                continue;
            }
            catch (InterruptedException e) {
                this.logger.warn("Concurrent execution interrupted", (Throwable)e);
                exceptions.add(new ExecutionException(e));
            }
        }
        return exceptions;
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

