/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.cmd;

import java.io.Serializable;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.api.Job;
import org.flowable.job.service.InternalJobManager;
import org.flowable.job.service.JobServiceConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockExclusiveJobCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(LockExclusiveJobCmd.class);
    protected JobServiceConfiguration jobServiceConfiguration;
    protected Job job;

    public LockExclusiveJobCmd(Job job, JobServiceConfiguration jobServiceConfiguration) {
        this.job = job;
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public Object execute(CommandContext commandContext) {
        InternalJobManager internalJobManager;
        if (this.job == null) {
            throw new FlowableIllegalArgumentException("job is null");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing lock exclusive job {} {}", (Object)this.job.getId(), (Object)this.job.getExecutionId());
        }
        if (this.job.isExclusive() && (this.job.getExecutionId() != null || this.job.getScopeId() != null) && (internalJobManager = this.jobServiceConfiguration.getInternalJobManager()) != null) {
            internalJobManager.lockJobScope(this.job);
        }
        return null;
    }
}

