/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.cmd;

import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.api.Job;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.persistence.entity.AbstractRuntimeJobEntity;

public class GetJobByCorrelationIdCmd
implements Command<Job> {
    protected JobServiceConfiguration jobServiceConfiguration;
    protected String correlationId;

    public GetJobByCorrelationIdCmd(String correlationId, JobServiceConfiguration jobServiceConfiguration) {
        this.correlationId = correlationId;
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public Job execute(CommandContext commandContext) {
        if (this.correlationId == null) {
            throw new FlowableIllegalArgumentException("correlationId is null");
        }
        AbstractRuntimeJobEntity job = this.jobServiceConfiguration.getDeadLetterJobEntityManager().findJobByCorrelationId(this.correlationId);
        if (job != null) {
            return job;
        }
        job = this.jobServiceConfiguration.getExternalWorkerJobEntityManager().findJobByCorrelationId(this.correlationId);
        if (job != null) {
            return job;
        }
        job = this.jobServiceConfiguration.getTimerJobEntityManager().findJobByCorrelationId(this.correlationId);
        if (job != null) {
            return job;
        }
        job = this.jobServiceConfiguration.getSuspendedJobEntityManager().findJobByCorrelationId(this.correlationId);
        if (job != null) {
            return job;
        }
        return this.jobServiceConfiguration.getJobEntityManager().findJobByCorrelationId(this.correlationId);
    }
}

