/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.logout.processor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.SessionKeyCredentials;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.exception.http.NoContentAction;
import org.pac4j.core.exception.http.OkAction;
import org.pac4j.core.logout.LogoutType;
import org.pac4j.core.logout.handler.SessionLogoutHandler;
import org.pac4j.core.logout.processor.LogoutProcessor;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.HttpActionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasLogoutProcessor
implements LogoutProcessor {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasLogoutProcessor.class);
    protected CasConfiguration configuration;
    protected SessionLogoutHandler sessionLogoutHandler;

    public CasLogoutProcessor(CasConfiguration configuration, SessionLogoutHandler sessionLogoutHandler) {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)configuration));
        this.configuration = configuration;
        this.sessionLogoutHandler = sessionLogoutHandler;
    }

    public HttpAction processLogout(CallContext ctx, Credentials logoutCredentials) {
        CommonHelper.assertTrue((boolean)(logoutCredentials instanceof SessionKeyCredentials), (String)"credentials must be of type SessionKeyCredentials");
        SessionKeyCredentials credentials = (SessionKeyCredentials)logoutCredentials;
        String sessionKey = credentials.getSessionKey();
        if (credentials.getLogoutType() == LogoutType.BACK) {
            if (StringUtils.isNotBlank((CharSequence)sessionKey) && this.sessionLogoutHandler != null) {
                this.sessionLogoutHandler.destroySession(ctx, sessionKey);
            }
            LOGGER.debug("back logout: no content returned");
            return NoContentAction.INSTANCE;
        }
        if (StringUtils.isNotBlank((CharSequence)sessionKey) && this.sessionLogoutHandler != null) {
            this.sessionLogoutHandler.destroySession(ctx, sessionKey);
        }
        HttpAction action = this.getFinalActionForFrontChannelLogout(ctx.webContext());
        LOGGER.debug("front logout, returning: {}", (Throwable)action);
        return action;
    }

    protected HttpAction getFinalActionForFrontChannelLogout(WebContext context) {
        Optional relayStateValue = context.getRequestParameter("RelayState");
        if (relayStateValue.isPresent()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.configuration.getPrefixUrl());
            if (!this.configuration.getPrefixUrl().endsWith("/")) {
                buffer.append("/");
            }
            buffer.append("logout?_eventId=next&");
            buffer.append("RelayState");
            buffer.append("=");
            buffer.append(CommonHelper.urlEncode((String)((String)relayStateValue.get())));
            String redirectUrl = buffer.toString();
            LOGGER.debug("Redirection url to the CAS server: {}", (Object)redirectUrl);
            return HttpActionHelper.buildRedirectUrlAction((WebContext)context, (String)redirectUrl);
        }
        return new OkAction("");
    }
}

