/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.util.HashMap;
import lombok.Generated;
import org.apereo.cas.authentication.PrincipalException;
import org.apereo.cas.services.RegisteredServiceAccessStrategyRequest;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.RegisteredServicePrincipalAccessStrategyEnforcer;
import org.apereo.cas.services.UnauthorizedServiceForPrincipalException;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class DefaultRegisteredServicePrincipalAccessStrategyEnforcer
implements RegisteredServicePrincipalAccessStrategyEnforcer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRegisteredServicePrincipalAccessStrategyEnforcer.class);
    private final ApplicationContext applicationContext;

    @Override
    public Boolean authorize(RegisteredServicePrincipalAccessStrategyEnforcer.PrincipalAccessStrategyContext context) {
        RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed(context.getService(), context.getRegisteredService());
        String serviceId = context.getService() != null ? context.getService().getId() : "unknown";
        LOGGER.trace("Checking access strategy for service [{}], requested by [{}] with attributes [{}].", new Object[]{serviceId, context.getPrincipalId(), context.getPrincipalAttributes()});
        RegisteredServiceAccessStrategyRequest accessRequest = RegisteredServiceAccessStrategyRequest.builder().service(context.getService()).principalId(context.getPrincipalId()).attributes(context.getPrincipalAttributes()).registeredService(context.getRegisteredService()).applicationContext(this.applicationContext).build();
        if (((Boolean)Unchecked.supplier(() -> !context.getRegisteredService().getAccessStrategy().authorizeRequest(accessRequest)).get()).booleanValue()) {
            LOGGER.warn("Cannot grant access to service [{}]; it is not authorized for use by [{}].", (Object)serviceId, (Object)context.getPrincipalId());
            HashMap<String, UnauthorizedServiceForPrincipalException> handlerErrors = new HashMap<String, UnauthorizedServiceForPrincipalException>();
            String message = String.format("Cannot authorize principal %s to access service %s, likely due to insufficient permissions", context.getPrincipalId(), serviceId);
            UnauthorizedServiceForPrincipalException exception = new UnauthorizedServiceForPrincipalException(message, context.getRegisteredService(), context.getPrincipalId(), context.getPrincipalAttributes());
            handlerErrors.put(UnauthorizedServiceForPrincipalException.class.getSimpleName(), exception);
            throw new PrincipalException(message, handlerErrors, new HashMap());
        }
        return true;
    }

    @Generated
    public DefaultRegisteredServicePrincipalAccessStrategyEnforcer(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

