/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.logout;

import lombok.Generated;
import org.apereo.cas.logout.LogoutPostProcessor;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.tracking.TicketTrackingPolicy;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DescendantTicketsLogoutPostProcessor
implements LogoutPostProcessor {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DescendantTicketsLogoutPostProcessor.class);
    private final TicketRegistry ticketRegistry;
    private final TicketTrackingPolicy descendantTicketsTrackingPolicy;

    public void handle(TicketGrantingTicket ticketGrantingTicket) {
        LOGGER.debug("CAS is configured to track and remove descendant tickets of the ticket-granting tickets");
        ticketGrantingTicket.getDescendantTickets().forEach(Unchecked.consumer(entry -> {
            LOGGER.trace("Deleting descendant ticket [{}] from the registry as a descendant of [{}]", entry, (Object)ticketGrantingTicket.getId());
            String ticket = this.descendantTicketsTrackingPolicy.extractTicket(entry);
            LOGGER.debug("Deleting ticket [{}] from the registry as a descendant of [{}]", (Object)ticket, (Object)ticketGrantingTicket.getId());
            this.ticketRegistry.deleteTicket(ticket);
        }));
    }

    @Generated
    public DescendantTicketsLogoutPostProcessor(TicketRegistry ticketRegistry, TicketTrackingPolicy descendantTicketsTrackingPolicy) {
        this.ticketRegistry = ticketRegistry;
        this.descendantTicketsTrackingPolicy = descendantTicketsTrackingPolicy;
    }
}

