/*
 * Decompiled with CFR 0.152.
 */
package com.okta.authn.sdk.impl.resource;

import com.okta.authn.sdk.impl.resource.DefaultFactor;
import com.okta.authn.sdk.impl.resource.DefaultLink;
import com.okta.authn.sdk.resource.AuthenticationResponse;
import com.okta.authn.sdk.resource.AuthenticationStatus;
import com.okta.authn.sdk.resource.Factor;
import com.okta.authn.sdk.resource.Link;
import com.okta.authn.sdk.resource.User;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.StringProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class DefaultAuthenticationResponse
extends AbstractResource
implements AuthenticationResponse {
    private static final StringProperty TYPE_PROPERTY = new StringProperty("type");
    private static final DateProperty EXPIRES_AT_PROPERTY = new DateProperty("expiresAt");
    private static final EnumProperty<AuthenticationStatus> STATUS_PROPERTY = new EnumProperty("status", AuthenticationStatus.class);
    private static final StringProperty FACTOR_RESULT_PROPERTY = new StringProperty("factorResult");
    private static final StringProperty FACTOR_RESULT_MESSAGE_PROPERTY = new StringProperty("factorResultMessage");
    private static final StringProperty STATE_TOKEN_PROPERTY = new StringProperty("stateToken");
    private static final StringProperty RELAY_STATE_PROPERTY = new StringProperty("relayState");
    private static final StringProperty RECOVERY_TOKEN_PROPERTY = new StringProperty("recoveryToken");
    private static final StringProperty SESSION_TOKEN_PROPERTY = new StringProperty("sessionToken");
    private static final StringProperty ID_TOKEN_PROPERTY = new StringProperty("idToken");
    private static final StringProperty FACTOR_TYPE_PROPERTY = new StringProperty("factorType");
    private static final StringProperty RECOVERY_TYPE_PROPERTY = new StringProperty("recoveryType");
    private static final MapProperty EMBEDDED_PROPERTY = new MapProperty("_embedded");
    private static final MapProperty LINKS_PROPERTY = new MapProperty("_links");
    private static final IntegerProperty CORRECT_ANSWER_PROPERTY = new IntegerProperty("correctAnswer");
    private static final StringProperty NESTED__USER_PROPERTY = new StringProperty("user");
    private static final StringProperty NESTED__FACTORS_PROPERTY = new StringProperty("factors");
    private static final StringProperty NESTED__FACTOR_PROPERTY = new StringProperty("factor");
    private static final StringProperty NESTED__CHALLENGE_PROPERTY = new StringProperty("challenge");

    public DefaultAuthenticationResponse(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    public Map<String, Property> getPropertyDescriptors() {
        return DefaultAuthenticationResponse.createPropertyDescriptorMap((Property[])new Property[]{TYPE_PROPERTY, EXPIRES_AT_PROPERTY, STATUS_PROPERTY, FACTOR_RESULT_PROPERTY, FACTOR_RESULT_MESSAGE_PROPERTY, STATE_TOKEN_PROPERTY, RELAY_STATE_PROPERTY, RECOVERY_TOKEN_PROPERTY, SESSION_TOKEN_PROPERTY, ID_TOKEN_PROPERTY, FACTOR_TYPE_PROPERTY, RECOVERY_TYPE_PROPERTY, EMBEDDED_PROPERTY, LINKS_PROPERTY, CORRECT_ANSWER_PROPERTY});
    }

    public String getStateToken() {
        return this.getString(STATE_TOKEN_PROPERTY);
    }

    public String getType() {
        return this.getString(TYPE_PROPERTY);
    }

    public Date getExpiresAt() {
        return this.getDateProperty(EXPIRES_AT_PROPERTY);
    }

    public AuthenticationStatus getStatus() {
        return (AuthenticationStatus)this.getEnumProperty(STATUS_PROPERTY);
    }

    public String getStatusString() {
        return this.getString(STATUS_PROPERTY.getName());
    }

    public String getFactorResult() {
        return this.getString(FACTOR_RESULT_PROPERTY);
    }

    public String getFactorResultMessage() {
        return this.getString(FACTOR_RESULT_MESSAGE_PROPERTY);
    }

    public String getRelayState() {
        return this.getString(RELAY_STATE_PROPERTY);
    }

    public String getRecoveryToken() {
        return this.getString(RECOVERY_TOKEN_PROPERTY);
    }

    public String getSessionToken() {
        return this.getString(SESSION_TOKEN_PROPERTY);
    }

    public String getIdToken() {
        return this.getString(ID_TOKEN_PROPERTY);
    }

    public String getFactorType() {
        return this.getString(FACTOR_TYPE_PROPERTY);
    }

    public String getRecoveryType() {
        return this.getString(RECOVERY_TYPE_PROPERTY);
    }

    public Map<String, Object> getEmbedded() {
        return this.getNonEmptyMap(EMBEDDED_PROPERTY);
    }

    public Map<String, Link> getLinks() {
        return DefaultLink.getLinks(this.getMap(LINKS_PROPERTY), this.getDataStore());
    }

    public User getUser() {
        Map userDetails = (Map)this.getEmbedded().get(NESTED__USER_PROPERTY.getName());
        if (userDetails != null) {
            return (User)this.getDataStore().instantiate(User.class, userDetails);
        }
        return null;
    }

    public List<Factor> getFactors() {
        ArrayList<Factor> result = new ArrayList<Factor>();
        List rawFactors = (List)this.getEmbedded().get(NESTED__FACTORS_PROPERTY.getName());
        if (rawFactors != null) {
            rawFactors.forEach(rawFactor -> result.add(new DefaultFactor(this.getDataStore(), (Map<String, Object>)rawFactor)));
        } else {
            Map rawFactor2 = (Map)this.getEmbedded().get(NESTED__FACTOR_PROPERTY.getName());
            if (rawFactor2 != null) {
                result.add(new DefaultFactor(this.getDataStore(), rawFactor2));
            }
        }
        return result;
    }

    public Integer getCorrectAnswer() {
        Map challenge;
        Map challengeFactorEmbedded;
        Map rawFactor = (Map)this.getEmbedded().get(NESTED__FACTOR_PROPERTY.getName());
        if (rawFactor != null && rawFactor.containsKey(EMBEDDED_PROPERTY.getName()) && (challengeFactorEmbedded = (Map)rawFactor.get(EMBEDDED_PROPERTY.getName())) != null && challengeFactorEmbedded.containsKey(NESTED__CHALLENGE_PROPERTY.getName()) && (challenge = (Map)challengeFactorEmbedded.get(NESTED__CHALLENGE_PROPERTY.getName())) != null && challenge.containsKey(CORRECT_ANSWER_PROPERTY.getName())) {
            return (Integer)challenge.get(CORRECT_ANSWER_PROPERTY.getName());
        }
        return null;
    }
}

