/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.ui.commons.resources.saml2sp4ui;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.util.Base64;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.saml2.SAML2Request;
import org.apache.syncope.common.lib.saml2.SAML2Response;
import org.apache.wicket.Session;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSAML2SP4UIResource
extends AbstractResource {
    private static final long serialVersionUID = 865306127846395310L;
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractSAML2SP4UIResource.class);

    protected String spEntityID(IResource.Attributes attributes) {
        HttpServletRequest request = (HttpServletRequest)attributes.getRequest().getContainerRequest();
        return StringUtils.substringBefore((String)request.getRequestURL().toString(), (String)"saml2sp4ui");
    }

    protected AbstractResource.ResourceResponse send(final SAML2Request request) {
        Session.get().setAttribute("saml2sp4ui.idpEntityID", (Serializable)((Object)request.getIdpEntityID()));
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        response.getHeaders().addHeader("Cache-Control", "no-cache, no-store");
        response.getHeaders().addHeader("Pragma", "no-cache");
        switch (request.getBindingType()) {
            case REDIRECT: {
                response.setStatusCode(Integer.valueOf(Response.Status.FOUND.getStatusCode()));
                response.getHeaders().addHeader("Location", request.getContent());
                break;
            }
            default: {
                response.setContentType("text/html");
                response.setWriteCallback(new AbstractResource.WriteCallback(this){

                    public void writeData(IResource.Attributes attributes) {
                        attributes.getResponse().write((CharSequence)new String(Base64.getMimeDecoder().decode(request.getContent())));
                    }
                });
            }
        }
        return response;
    }

    protected SAML2Response buildResponse(IResource.Attributes attributes, String samlResponse, String relayState) {
        SAML2Response response = new SAML2Response();
        response.setIdpEntityID((String)((Object)Session.get().getAttribute("saml2sp4ui.idpEntityID")));
        if (StringUtils.isBlank((CharSequence)response.getIdpEntityID())) {
            response.setIdpEntityID(attributes.getRequest().getQueryParameters().getParameterValue("saml2sp4ui.idpEntityID").toOptionalString());
            if (StringUtils.isBlank((CharSequence)response.getIdpEntityID())) {
                Stream.of(((HttpServletRequest)attributes.getRequest().getContainerRequest()).getCookies()).filter(cookie -> "saml2sp4ui.idpEntityID".equals(cookie.getName())).findFirst().ifPresent(cookie -> response.setIdpEntityID(cookie.getValue()));
            }
        }
        response.setSpEntityID(this.spEntityID(attributes));
        response.setUrlContext("saml2sp4ui");
        response.setSamlResponse(samlResponse);
        response.setRelayState(relayState);
        return response;
    }

    protected SAML2Response extract(IResource.Attributes attributes) {
        String samlResponse = attributes.getRequest().getRequestParameters().getParameterValue("SAMLResponse").toOptionalString();
        LOG.debug("Received SAML Response: {}", (Object)samlResponse);
        String relayState = attributes.getRequest().getRequestParameters().getParameterValue("RelayState").toOptionalString();
        LOG.debug("Received Relay State: {}", (Object)relayState);
        return this.buildResponse(attributes, samlResponse, relayState);
    }
}

