/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Statistic;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.atlas.AtlasCounterBatchUpdater;
import com.netflix.spectator.atlas.AtlasMeter;
import com.netflix.spectator.atlas.DsType;
import com.netflix.spectator.atlas.MeasurementConsumer;
import com.netflix.spectator.impl.StepDouble;

class AtlasCounter
extends AtlasMeter
implements Counter {
    private final StepDouble value;
    private final Id stat;

    AtlasCounter(Id id, Clock clock, long ttl, long step) {
        super(id, clock, ttl);
        this.value = new StepDouble(0.0, clock, step);
        this.stat = AtlasMeter.addIfMissing(id, (Tag)Statistic.count, DsType.rate);
    }

    @Override
    void measure(long now, MeasurementConsumer consumer) {
        double rate = this.value.pollAsRate(now);
        consumer.accept(this.stat, this.value.timestamp(), rate);
    }

    public void add(double amount) {
        if (Double.isFinite(amount) && amount > 0.0) {
            long now = this.clock.wallTime();
            this.value.addAndGet(now, amount);
            this.updateLastModTime(now);
        }
    }

    public double actualCount() {
        return this.value.poll();
    }

    public Counter.BatchUpdater batchUpdater(int batchSize) {
        AtlasCounterBatchUpdater updater = new AtlasCounterBatchUpdater(batchSize);
        updater.accept(() -> this);
        return updater;
    }
}

