/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.metadata;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.util.IOUtils;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.ClientSecretPost;
import com.nimbusds.oauth2.sdk.auth.PrivateKeyJWT;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import lombok.Generated;
import org.pac4j.core.resource.SpringResourceHelper;
import org.pac4j.core.resource.SpringResourceLoader;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oidc.config.OidcConfiguration;
import org.pac4j.oidc.config.PrivateKeyJWTClientAuthnMethodConfig;
import org.pac4j.oidc.exceptions.OidcException;
import org.pac4j.oidc.exceptions.OidcUnsupportedClientAuthMethodException;
import org.pac4j.oidc.profile.creator.TokenValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class OidcOpMetadataResolver
extends SpringResourceLoader<OIDCProviderMetadata> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcOpMetadataResolver.class);
    private static final Collection<ClientAuthenticationMethod> SUPPORTED_METHODS = Arrays.asList(ClientAuthenticationMethod.CLIENT_SECRET_POST, ClientAuthenticationMethod.CLIENT_SECRET_BASIC, ClientAuthenticationMethod.PRIVATE_KEY_JWT, ClientAuthenticationMethod.NONE);
    protected final OidcConfiguration configuration;
    protected ClientAuthentication clientAuthentication;
    protected TokenValidator tokenValidator;

    public OidcOpMetadataResolver(OidcConfiguration configuration) {
        super(OidcOpMetadataResolver.buildResource(configuration));
        this.configuration = configuration;
    }

    private static Resource buildResource(OidcConfiguration configuration) {
        if (configuration != null && configuration.getDiscoveryURI() != null) {
            return SpringResourceHelper.buildResourceFromPath((String)configuration.getDiscoveryURI());
        }
        return null;
    }

    protected void internalLoad() {
        this.loaded = this.retrieveMetadata();
        this.clientAuthentication = this.computeClientAuthentication();
        this.tokenValidator = this.createTokenValidator();
    }

    protected OIDCProviderMetadata retrieveMetadata() {
        OIDCProviderMetadata oIDCProviderMetadata;
        block8: {
            InputStream in = SpringResourceHelper.getResourceInputStream((Resource)this.resource, null, (SSLSocketFactory)this.configuration.getSslSocketFactory(), (HostnameVerifier)this.configuration.getHostnameVerifier(), (int)this.configuration.getConnectTimeout(), (int)this.configuration.getReadTimeout());
            try {
                String metadata = IOUtils.readInputStreamToString((InputStream)in);
                oIDCProviderMetadata = OIDCProviderMetadata.parse((String)metadata);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ParseException | IOException e) {
                    throw new OidcException("Error getting OP metadata", e);
                }
            }
            in.close();
        }
        return oIDCProviderMetadata;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ClientAuthentication computeClientAuthentication() {
        ClientAuthenticationMethod chosenMethod;
        ClientID _clientID = new ClientID(this.configuration.getClientId());
        if (this.configuration.getSecret() == null && this.configuration.getPrivateKeyJWTClientAuthnMethodConfig() == null) return null;
        List serverSupportedAuthMethods = ((OIDCProviderMetadata)this.loaded).getTokenEndpointAuthMethods();
        ClientAuthenticationMethod preferredMethod = OidcOpMetadataResolver.getPreferredAuthenticationMethod(this.configuration);
        if (CommonHelper.isNotEmpty((Collection)serverSupportedAuthMethods)) {
            if (preferredMethod != null) {
                if (!serverSupportedAuthMethods.contains(preferredMethod)) throw new OidcUnsupportedClientAuthMethodException("Preferred authentication method (" + preferredMethod + ") not supported by provider according to provider metadata (" + serverSupportedAuthMethods + ").");
                chosenMethod = preferredMethod;
            } else {
                chosenMethod = OidcOpMetadataResolver.firstSupportedMethod(serverSupportedAuthMethods, this.configuration.getSupportedClientAuthenticationMethods());
            }
        } else {
            chosenMethod = preferredMethod != null ? preferredMethod : ClientAuthenticationMethod.getDefault();
            LOGGER.info("Provider metadata does not provide Token endpoint authentication methods. Using: {}", (Object)chosenMethod);
        }
        if (ClientAuthenticationMethod.CLIENT_SECRET_POST.equals((Object)chosenMethod)) {
            Secret _secret = new Secret(this.configuration.getSecret());
            return new ClientSecretPost(_clientID, _secret);
        }
        if (ClientAuthenticationMethod.CLIENT_SECRET_BASIC.equals((Object)chosenMethod)) {
            Secret _secret = new Secret(this.configuration.getSecret());
            return new ClientSecretBasic(_clientID, _secret);
        }
        if (!ClientAuthenticationMethod.PRIVATE_KEY_JWT.equals((Object)chosenMethod)) throw new OidcUnsupportedClientAuthMethodException("Unsupported client authentication method: " + chosenMethod);
        PrivateKeyJWTClientAuthnMethodConfig privateKeyJwtConfig = this.configuration.getPrivateKeyJWTClientAuthnMethodConfig();
        CommonHelper.assertNotNull((String)"privateKeyJwtConfig", (Object)privateKeyJwtConfig);
        JWSAlgorithm jwsAlgo = privateKeyJwtConfig.getJwsAlgorithm();
        CommonHelper.assertNotNull((String)"privateKeyJwtConfig.getJwsAlgorithm()", (Object)jwsAlgo);
        PrivateKey privateKey = privateKeyJwtConfig.getPrivateKey();
        CommonHelper.assertNotNull((String)"privateKeyJwtConfig.getPrivateKey()", (Object)privateKey);
        String keyID = privateKeyJwtConfig.getKeyID();
        try {
            return new PrivateKeyJWT(_clientID, ((OIDCProviderMetadata)this.loaded).getTokenEndpointURI(), jwsAlgo, privateKey, keyID, null);
        }
        catch (JOSEException e) {
            throw new OidcException("Cannot instantiate private key JWT client authentication method", e);
        }
    }

    private static ClientAuthenticationMethod getPreferredAuthenticationMethod(OidcConfiguration config) {
        ClientAuthenticationMethod configurationMethod = config.getClientAuthenticationMethod();
        if (configurationMethod == null) {
            return null;
        }
        if (!SUPPORTED_METHODS.contains(configurationMethod)) {
            throw new OidcUnsupportedClientAuthMethodException("Configured authentication method (" + configurationMethod + ") is not supported.");
        }
        return configurationMethod;
    }

    private static ClientAuthenticationMethod firstSupportedMethod(Collection<ClientAuthenticationMethod> serverSupportedAuthMethods, Collection<ClientAuthenticationMethod> clientSupportedAuthMethods) {
        Collection<ClientAuthenticationMethod> supportedMethods = clientSupportedAuthMethods != null ? clientSupportedAuthMethods : SUPPORTED_METHODS;
        Optional<ClientAuthenticationMethod> firstSupported = serverSupportedAuthMethods.stream().filter(supportedMethods::contains).findFirst();
        if (firstSupported.isPresent()) {
            return firstSupported.get();
        }
        throw new OidcUnsupportedClientAuthMethodException("None of the Token endpoint provider metadata authentication methods are supported: " + serverSupportedAuthMethods);
    }

    protected TokenValidator createTokenValidator() {
        return new TokenValidator(this.configuration, (OIDCProviderMetadata)this.loaded);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClientAuthentication getClientAuthentication() {
        return this.clientAuthentication;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TokenValidator getTokenValidator() {
        return this.tokenValidator;
    }
}

