/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.common.clients.service.token;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.wavefront.sdk.common.NamedThreadFactory;
import com.wavefront.sdk.common.clients.service.token.CSPAuthorizeResponse;
import com.wavefront.sdk.common.clients.service.token.CSPURLConnectionFactory;
import com.wavefront.sdk.common.clients.service.token.TokenService;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

public class CSPTokenService
implements TokenService,
Runnable {
    private static final String INVALID_TOKEN = "INVALID_TOKEN";
    private static final Logger log = Logger.getLogger(CSPTokenService.class.getCanonicalName());
    private final AtomicBoolean tokenReady = new AtomicBoolean(false);
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, new NamedThreadFactory("csp-token-service"));
    private final ObjectMapper mapper = new ObjectMapper().findAndRegisterModules();
    private String cspAccessToken;
    private CSPURLConnectionFactory cspUrlConnectionFactory;
    protected static Duration DEFAULT_THREAD_DELAY = Duration.ofSeconds(60L);

    public CSPTokenService(CSPURLConnectionFactory cspUrlConnection) {
        this.cspUrlConnectionFactory = cspUrlConnection;
    }

    @Override
    public synchronized String getToken() {
        if (!this.tokenReady.get()) {
            this.run();
            this.tokenReady.set(true);
        }
        return this.cspAccessToken;
    }

    @Override
    public TokenService.Type getType() {
        return this.cspUrlConnectionFactory.getTokenType();
    }

    @Override
    public synchronized void run() {
        this.cspAccessToken = this.getCSPToken();
    }

    protected String getCSPToken() {
        try {
            HttpURLConnection urlConn = this.cspUrlConnectionFactory.build();
            DataOutputStream wr = new DataOutputStream(urlConn.getOutputStream());
            wr.write(this.cspUrlConnectionFactory.getPostData());
            wr.flush();
            wr.close();
            int statusCode = urlConn.getResponseCode();
            if (statusCode == 200) {
                try {
                    CSPAuthorizeResponse parsedResponse = (CSPAuthorizeResponse)this.mapper.readValue(urlConn.getInputStream(), CSPAuthorizeResponse.class);
                    Duration threadDelay = this.getThreadDelay(parsedResponse.expiresIn);
                    log.info("Received CSP token and will refresh in " + threadDelay.getSeconds() + " seconds.");
                    this.executor.schedule(this, threadDelay.getSeconds(), TimeUnit.SECONDS);
                    return parsedResponse.accessToken;
                }
                catch (JsonProcessingException e) {
                    log.severe("The request to CSP returned invalid json. Please restart your app.");
                    return INVALID_TOKEN;
                }
            }
            log.severe("The request to CSP for a token failed with HTTP " + statusCode + ".");
            if (statusCode >= 500 && statusCode < 600) {
                log.info("The Wavefront SDK will try to reauthenticate with CSP on the next request.");
                this.tokenReady.set(false);
                return null;
            }
            return INVALID_TOKEN;
        }
        catch (IOException ex) {
            log.warning("Error connecting to CSP: " + ex.getLocalizedMessage());
            log.info("The Wavefront SDK will try to reauthenticate with CSP on the next request.");
            this.tokenReady.set(false);
            return null;
        }
    }

    protected Duration getThreadDelay(Duration expiresIn) {
        Duration delay = expiresIn.compareTo(Duration.ofMinutes(10L)) < 0 ? expiresIn.minusSeconds(30L) : expiresIn.minusMinutes(3L);
        if (delay.isZero() || delay.isNegative()) {
            delay = DEFAULT_THREAD_DELAY;
        }
        return delay;
    }
}

