/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.record.AbstractLegacyRecordBatch;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AbstractLegacyRecordBatchTest {
    @Test
    public void testSetLastOffsetCompressed() {
        SimpleRecord[] simpleRecords = new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes())};
        MemoryRecords records = MemoryRecords.withRecords((byte)1, (long)0L, (Compression)Compression.gzip().build(), (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])simpleRecords);
        long lastOffset = 500L;
        long firstOffset = lastOffset - (long)simpleRecords.length + 1L;
        AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch batch = new AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch(records.buffer());
        batch.setLastOffset(lastOffset);
        Assertions.assertEquals((long)lastOffset, (long)batch.lastOffset());
        Assertions.assertEquals((long)firstOffset, (long)batch.baseOffset());
        Assertions.assertTrue((boolean)batch.isValid());
        List recordBatches = Utils.toList(records.batches().iterator());
        Assertions.assertEquals((int)1, (int)recordBatches.size());
        Assertions.assertEquals((long)lastOffset, (long)((MutableRecordBatch)recordBatches.get(0)).lastOffset());
        long offset = firstOffset;
        for (Record record : records.records()) {
            Assertions.assertEquals((long)offset++, (long)record.offset());
        }
    }

    @Test
    public void testIterateCompressedRecordWithWrapperOffsetZero() {
        for (byte magic : Arrays.asList((byte)0, (byte)1)) {
            SimpleRecord[] simpleRecords = new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes())};
            MemoryRecords records = MemoryRecords.withRecords((byte)magic, (long)0L, (Compression)Compression.gzip().build(), (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])simpleRecords);
            AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch batch = new AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch(records.buffer());
            batch.setLastOffset(0L);
            long offset = 0L;
            for (Record record : batch) {
                Assertions.assertEquals((long)offset++, (long)record.offset());
            }
        }
    }

    @Test
    public void testInvalidWrapperOffsetV1() {
        SimpleRecord[] simpleRecords = new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes())};
        MemoryRecords records = MemoryRecords.withRecords((byte)1, (long)0L, (Compression)Compression.gzip().build(), (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])simpleRecords);
        AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch batch = new AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch(records.buffer());
        batch.setLastOffset(1L);
        Assertions.assertThrows(InvalidRecordException.class, () -> ((AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch)batch).iterator());
    }

    @Test
    public void testSetNoTimestampTypeNotAllowed() {
        MemoryRecords records = MemoryRecords.withRecords((byte)1, (long)0L, (Compression)Compression.gzip().build(), (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes())});
        AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch batch = new AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch(records.buffer());
        Assertions.assertThrows(IllegalArgumentException.class, () -> batch.setMaxTimestamp(TimestampType.NO_TIMESTAMP_TYPE, -1L));
    }

    @Test
    public void testSetLogAppendTimeNotAllowedV0() {
        MemoryRecords records = MemoryRecords.withRecords((byte)0, (long)0L, (Compression)Compression.gzip().build(), (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes())});
        long logAppendTime = 15L;
        AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch batch = new AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch(records.buffer());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> batch.setMaxTimestamp(TimestampType.LOG_APPEND_TIME, logAppendTime));
    }

    @Test
    public void testSetCreateTimeNotAllowedV0() {
        MemoryRecords records = MemoryRecords.withRecords((byte)0, (long)0L, (Compression)Compression.gzip().build(), (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes())});
        long createTime = 15L;
        AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch batch = new AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch(records.buffer());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> batch.setMaxTimestamp(TimestampType.CREATE_TIME, createTime));
    }

    @Test
    public void testSetPartitionLeaderEpochNotAllowedV0() {
        MemoryRecords records = MemoryRecords.withRecords((byte)0, (long)0L, (Compression)Compression.gzip().build(), (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes())});
        AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch batch = new AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch(records.buffer());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> batch.setPartitionLeaderEpoch(15));
    }

    @Test
    public void testSetPartitionLeaderEpochNotAllowedV1() {
        MemoryRecords records = MemoryRecords.withRecords((byte)1, (long)0L, (Compression)Compression.gzip().build(), (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes())});
        AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch batch = new AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch(records.buffer());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> batch.setPartitionLeaderEpoch(15));
    }

    @Test
    public void testSetLogAppendTimeV1() {
        MemoryRecords records = MemoryRecords.withRecords((byte)1, (long)0L, (Compression)Compression.gzip().build(), (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes())});
        long logAppendTime = 15L;
        AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch batch = new AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch(records.buffer());
        batch.setMaxTimestamp(TimestampType.LOG_APPEND_TIME, logAppendTime);
        Assertions.assertEquals((Object)TimestampType.LOG_APPEND_TIME, (Object)batch.timestampType());
        Assertions.assertEquals((long)logAppendTime, (long)batch.maxTimestamp());
        Assertions.assertTrue((boolean)batch.isValid());
        List recordBatches = Utils.toList(records.batches().iterator());
        Assertions.assertEquals((int)1, (int)recordBatches.size());
        Assertions.assertEquals((Object)TimestampType.LOG_APPEND_TIME, (Object)((MutableRecordBatch)recordBatches.get(0)).timestampType());
        Assertions.assertEquals((long)logAppendTime, (long)((MutableRecordBatch)recordBatches.get(0)).maxTimestamp());
        for (Record record : records.records()) {
            Assertions.assertEquals((long)logAppendTime, (long)record.timestamp());
        }
    }

    @Test
    public void testSetCreateTimeV1() {
        MemoryRecords records = MemoryRecords.withRecords((byte)1, (long)0L, (Compression)Compression.gzip().build(), (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes())});
        long createTime = 15L;
        AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch batch = new AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch(records.buffer());
        batch.setMaxTimestamp(TimestampType.CREATE_TIME, createTime);
        Assertions.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
        Assertions.assertEquals((long)createTime, (long)batch.maxTimestamp());
        Assertions.assertTrue((boolean)batch.isValid());
        List recordBatches = Utils.toList(records.batches().iterator());
        Assertions.assertEquals((int)1, (int)recordBatches.size());
        Assertions.assertEquals((Object)TimestampType.CREATE_TIME, (Object)((MutableRecordBatch)recordBatches.get(0)).timestampType());
        Assertions.assertEquals((long)createTime, (long)((MutableRecordBatch)recordBatches.get(0)).maxTimestamp());
        long expectedTimestamp = 1L;
        for (Record record : records.records()) {
            Assertions.assertEquals((long)expectedTimestamp++, (long)record.timestamp());
        }
    }

    @Test
    public void testZStdCompressionTypeWithV0OrV1() {
        AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch batch;
        MemoryRecords records;
        SimpleRecord[] simpleRecords = new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes())};
        try {
            records = MemoryRecords.withRecords((byte)0, (long)0L, (Compression)Compression.zstd().build(), (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])simpleRecords);
            batch = new AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch(records.buffer());
            batch.setLastOffset(1L);
            batch.iterator();
            Assertions.fail((String)"Can't reach here");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"ZStandard compression is not supported for magic 0", (Object)e.getMessage());
        }
        try {
            records = MemoryRecords.withRecords((byte)1, (long)0L, (Compression)Compression.zstd().build(), (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])simpleRecords);
            batch = new AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch(records.buffer());
            batch.setLastOffset(1L);
            batch.iterator();
            Assertions.fail((String)"Can't reach here");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"ZStandard compression is not supported for magic 1", (Object)e.getMessage());
        }
    }
}

