/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.CooperativeStickyAssignor;
import org.apache.kafka.clients.consumer.RangeAssignor;
import org.apache.kafka.clients.consumer.StickyAssignor;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConsumerPartitionAssignorTest {
    @Test
    public void shouldInstantiateAssignor() {
        List assignors = ConsumerPartitionAssignor.getAssignorInstances(Collections.singletonList(StickyAssignor.class.getName()), Collections.emptyMap());
        Assertions.assertInstanceOf(StickyAssignor.class, assignors.get(0));
    }

    @Test
    public void shouldInstantiateListOfAssignors() {
        List assignors = ConsumerPartitionAssignor.getAssignorInstances(Arrays.asList(StickyAssignor.class.getName(), CooperativeStickyAssignor.class.getName()), Collections.emptyMap());
        Assertions.assertInstanceOf(StickyAssignor.class, assignors.get(0));
        Assertions.assertInstanceOf(CooperativeStickyAssignor.class, assignors.get(1));
    }

    @Test
    public void shouldThrowKafkaExceptionOnNonAssignor() {
        Assertions.assertThrows(KafkaException.class, () -> ConsumerPartitionAssignor.getAssignorInstances(Collections.singletonList(String.class.getName()), Collections.emptyMap()));
    }

    @Test
    public void shouldThrowKafkaExceptionOnAssignorNotFound() {
        Assertions.assertThrows(KafkaException.class, () -> ConsumerPartitionAssignor.getAssignorInstances(Collections.singletonList("Non-existent assignor"), Collections.emptyMap()));
    }

    @Test
    public void shouldInstantiateFromClassType() {
        List classTypes = this.initConsumerConfigWithClassTypes(Collections.singletonList(StickyAssignor.class)).getList("partition.assignment.strategy");
        List assignors = ConsumerPartitionAssignor.getAssignorInstances((List)classTypes, Collections.emptyMap());
        Assertions.assertInstanceOf(StickyAssignor.class, assignors.get(0));
    }

    @Test
    public void shouldInstantiateFromListOfClassTypes() {
        List classTypes = this.initConsumerConfigWithClassTypes(Arrays.asList(StickyAssignor.class, CooperativeStickyAssignor.class)).getList("partition.assignment.strategy");
        List assignors = ConsumerPartitionAssignor.getAssignorInstances((List)classTypes, Collections.emptyMap());
        Assertions.assertInstanceOf(StickyAssignor.class, assignors.get(0));
        Assertions.assertInstanceOf(CooperativeStickyAssignor.class, assignors.get(1));
    }

    @Test
    public void shouldThrowKafkaExceptionOnListWithNonAssignorClassType() {
        List classTypes = this.initConsumerConfigWithClassTypes(Arrays.asList(StickyAssignor.class, String.class)).getList("partition.assignment.strategy");
        Assertions.assertThrows(KafkaException.class, () -> ConsumerPartitionAssignor.getAssignorInstances((List)classTypes, Collections.emptyMap()));
    }

    @Test
    public void shouldThrowKafkaExceptionOnAssignorsWithSameName() {
        Assertions.assertThrows(KafkaException.class, () -> ConsumerPartitionAssignor.getAssignorInstances(Arrays.asList(RangeAssignor.class.getName(), TestConsumerPartitionAssignor.class.getName()), Collections.emptyMap()));
    }

    @Test
    public void shouldBeConfigurable() {
        Map<String, String> configs = Collections.singletonMap("key", "value");
        List assignors = ConsumerPartitionAssignor.getAssignorInstances(Collections.singletonList(TestConsumerPartitionAssignor.class.getName()), configs);
        Assertions.assertEquals((int)1, (int)assignors.size());
        Assertions.assertInstanceOf(TestConsumerPartitionAssignor.class, assignors.get(0));
        Assertions.assertEquals(configs, (Object)((TestConsumerPartitionAssignor)assignors.get(0)).configs);
    }

    private ConsumerConfig initConsumerConfigWithClassTypes(List<Object> classTypes) {
        Properties props = new Properties();
        props.put("key.deserializer", StringDeserializer.class);
        props.put("value.deserializer", StringDeserializer.class);
        props.put("partition.assignment.strategy", classTypes);
        return new ConsumerConfig(props);
    }

    public static class TestConsumerPartitionAssignor
    implements ConsumerPartitionAssignor,
    Configurable {
        private Map<String, ?> configs = null;

        public ConsumerPartitionAssignor.GroupAssignment assign(Cluster metadata, ConsumerPartitionAssignor.GroupSubscription groupSubscription) {
            return null;
        }

        public String name() {
            return new RangeAssignor().name();
        }

        public void configure(Map<String, ?> configs) {
            this.configs = configs;
        }
    }
}

