/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;

public final class JavaDocUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JavaDocUtils.class);

    private static URL toURL(String classPathEntry) {
        try {
            return Path.of(classPathEntry, new String[0]).toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("URL could not be created from '" + classPathEntry + "'", e);
        }
    }

    private static URL[] urlsFromClassLoader(ClassLoader classLoader) {
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            return urlClassLoader.getURLs();
        }
        return (URL[])Stream.of(ManagementFactory.getRuntimeMXBean().getClassPath().split(File.pathSeparator)).map(JavaDocUtils::toURL).toArray(URL[]::new);
    }

    public static Optional<URL[]> getJavaDocURLs() {
        URL[] urls = JavaDocUtils.urlsFromClassLoader(ClassUtils.getDefaultClassLoader());
        if (urls == null) {
            LOG.debug("No classpath URLs found");
            return Optional.empty();
        }
        ArrayList<URL> javaDocURLs = new ArrayList<URL>();
        for (URL url : urls) {
            LOG.debug("Processing {}", (Object)url.toExternalForm());
            String filename = StringUtils.substringAfterLast((String)url.toExternalForm(), (String)"/");
            if (!filename.startsWith("syncope-") || !filename.endsWith("-javadoc.jar")) continue;
            javaDocURLs.add(url);
        }
        LOG.debug("JavaDoc Urls found: {}", javaDocURLs);
        return Optional.of((URL[])javaDocURLs.toArray(URL[]::new));
    }

    public static Optional<String[]> getJavaDocPaths(Environment env) {
        String[] result = null;
        if (env.containsProperty("javadocPaths")) {
            result = Objects.requireNonNull(env.getProperty("javadocPaths")).split(",");
        }
        LOG.debug("JavaDoc paths found: {}", result == null ? List.of() : Arrays.stream(result).toList());
        return Optional.ofNullable(result);
    }

    private JavaDocUtils() {
    }
}

