/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.handler.impl;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.servlet.HttpServletRequestValidator;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.slf4j.Logger;

public class HttpServletRequestValidationHandler
extends AbstractMessageHandler {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(HttpServletRequestValidationHandler.class);
    @NonnullAfterInit
    private HttpServletRequestValidator validator;
    @NonnullAfterInit
    private NonnullSupplier<HttpServletRequest> httpServletRequestSupplier;

    @NonnullAfterInit
    public HttpServletRequest getHttpServletRequest() {
        if (this.httpServletRequestSupplier == null) {
            return null;
        }
        return (HttpServletRequest)this.httpServletRequestSupplier.get();
    }

    @NonnullAfterInit
    public NonnullSupplier<HttpServletRequest> getHttpServletRequestSupplier() {
        return this.httpServletRequestSupplier;
    }

    public void setHttpServletRequestSupplier(@Nullable NonnullSupplier<HttpServletRequest> requestSupplier) {
        this.checkSetterPreconditions();
        this.httpServletRequestSupplier = requestSupplier;
    }

    @NonnullAfterInit
    public HttpServletRequestValidator getValidator() {
        return this.validator;
    }

    public void setValidator(@Nullable HttpServletRequestValidator newValidator) {
        this.checkSetterPreconditions();
        this.validator = newValidator;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getHttpServletRequest() == null) {
            throw new ComponentInitializationException("HttpServletRequest was null");
        }
        if (this.getValidator() == null) {
            throw new ComponentInitializationException("HttpServletRequestValidator was null");
        }
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        try {
            this.getValidator().validate(this.getHttpServletRequest());
        }
        catch (ServletException e) {
            throw new MessageHandlerException("HttpServletRequest was invalid", (Exception)((Object)e));
        }
    }
}

