/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.spring;

import jakarta.persistence.ValidationMode;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.syncope.core.persistence.api.DomainHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitPostProcessor;

public class CommonEntityManagerFactoryConf
implements DomainHolder<DataSource> {
    private static final Logger LOG = LoggerFactory.getLogger(DomainHolder.class);
    private final Map<String, DataSource> domains = new ConcurrentHashMap<String, DataSource>();
    private String[] packagesToScan;
    private ValidationMode validationMode;
    private PersistenceUnitPostProcessor[] postProcessors;
    private final Map<String, Object> jpaPropertyMap = new HashMap<String, Object>();

    public Map<String, DataSource> getDomains() {
        return this.domains;
    }

    public Map<String, Boolean> getHealthInfo() {
        HashMap<String, Boolean> healthInfo = new HashMap<String, Boolean>(this.domains.size());
        this.domains.forEach((domain, dataSource) -> {
            try (Connection conn = DataSourceUtils.getConnection((DataSource)dataSource);){
                healthInfo.put((String)domain, conn.isValid(0));
            }
            catch (Exception e) {
                healthInfo.put((String)domain, false);
                LOG.debug("When attempting to connect to Domain {}", domain, (Object)e);
            }
        });
        return healthInfo;
    }

    public String[] getPackagesToScan() {
        return this.packagesToScan;
    }

    public void setPackagesToScan(String ... packagesToScan) {
        this.packagesToScan = packagesToScan;
    }

    public ValidationMode getValidationMode() {
        return this.validationMode;
    }

    public void setValidationMode(ValidationMode validationMode) {
        this.validationMode = validationMode;
    }

    public PersistenceUnitPostProcessor[] getPersistenceUnitPostProcessors() {
        return this.postProcessors;
    }

    public void setPersistenceUnitPostProcessors(PersistenceUnitPostProcessor ... postProcessors) {
        this.postProcessors = postProcessors;
    }

    public Map<String, ?> getJpaPropertyMap() {
        return this.jpaPropertyMap;
    }

    public void setJpaPropertyMap(Map<String, ?> jpaProperties) {
        if (jpaProperties != null) {
            this.jpaPropertyMap.putAll(jpaProperties);
        }
    }
}

