/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity.task;

import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtils;
import org.apache.syncope.core.persistence.jpa.entity.task.AbstractTask;
import org.apache.syncope.core.persistence.jpa.entity.task.AbstractTaskExec;
import org.apache.syncope.core.persistence.jpa.entity.task.JPALiveSyncTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPALiveSyncTaskExec;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAMacroTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAMacroTaskExec;
import org.apache.syncope.core.persistence.jpa.entity.task.JPANotificationTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPANotificationTaskExec;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAPropagationTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAPropagationTaskExec;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAPullTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAPullTaskExec;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAPushTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAPushTaskExec;
import org.apache.syncope.core.persistence.jpa.entity.task.JPASchedTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPASchedTaskExec;
import org.apache.syncope.core.spring.security.SecureRandomUtils;

public final class JPATaskUtils
implements TaskUtils {
    protected final TaskType type;

    protected JPATaskUtils(TaskType type) {
        this.type = type;
    }

    public TaskType getType() {
        return this.type;
    }

    public <T extends Task<T>> T newTask() {
        AbstractTask result = null;
        switch (this.type) {
            case PROPAGATION: {
                result = new JPAPropagationTask();
                break;
            }
            case SCHEDULED: {
                result = new JPASchedTask();
                break;
            }
            case LIVE_SYNC: {
                result = new JPALiveSyncTask();
                break;
            }
            case PULL: {
                result = new JPAPullTask();
                break;
            }
            case PUSH: {
                result = new JPAPushTask();
                break;
            }
            case MACRO: {
                result = new JPAMacroTask();
                break;
            }
            case NOTIFICATION: {
                result = new JPANotificationTask();
                break;
            }
        }
        if (result != null) {
            ((AbstractTask)result).setKey(SecureRandomUtils.generateRandomUUID().toString());
        }
        return (T)result;
    }

    public <E extends TaskExec<?>> E newTaskExec() {
        AbstractTaskExec result = switch (this.type) {
            case TaskType.NOTIFICATION -> new JPANotificationTaskExec();
            case TaskType.PROPAGATION -> new JPAPropagationTaskExec();
            case TaskType.LIVE_SYNC -> new JPALiveSyncTaskExec();
            case TaskType.PULL -> new JPAPullTaskExec();
            case TaskType.PUSH -> new JPAPushTaskExec();
            case TaskType.MACRO -> new JPAMacroTaskExec();
            case TaskType.SCHEDULED -> new JPASchedTaskExec();
            default -> null;
        };
        if (result != null) {
            ((AbstractTaskExec)result).setKey(SecureRandomUtils.generateRandomUUID().toString());
        }
        return (E)result;
    }

    public String getTaskStorage() {
        String result = null;
        switch (this.type) {
            case NOTIFICATION: {
                result = "NotificationTask";
                break;
            }
            case PROPAGATION: {
                result = "PropagationTask";
                break;
            }
            case PUSH: {
                result = "PushTask";
                break;
            }
            case LIVE_SYNC: {
                result = "LiveSyncTask";
                break;
            }
            case PULL: {
                result = "PullTask";
                break;
            }
            case MACRO: {
                result = "MacroTask";
                break;
            }
            case SCHEDULED: {
                result = "SchedTask";
                break;
            }
        }
        return result;
    }

    public Class<? extends Task<?>> getTaskEntity() {
        Class result = null;
        switch (this.type) {
            case NOTIFICATION: {
                result = JPANotificationTask.class;
                break;
            }
            case PROPAGATION: {
                result = JPAPropagationTask.class;
                break;
            }
            case PUSH: {
                result = JPAPushTask.class;
                break;
            }
            case LIVE_SYNC: {
                result = JPALiveSyncTask.class;
                break;
            }
            case PULL: {
                result = JPAPullTask.class;
                break;
            }
            case MACRO: {
                result = JPAMacroTask.class;
                break;
            }
            case SCHEDULED: {
                result = JPASchedTask.class;
                break;
            }
        }
        return result;
    }

    public String getTaskExecStorage() {
        String result = null;
        switch (this.type) {
            case NOTIFICATION: {
                result = "NotificationTaskExec";
                break;
            }
            case PROPAGATION: {
                result = "PropagationTaskExec";
                break;
            }
            case SCHEDULED: {
                result = "SchedTaskExec";
                break;
            }
            case PUSH: {
                result = "PushTaskExec";
                break;
            }
            case LIVE_SYNC: {
                result = "LiveSyncTaskExec";
                break;
            }
            case PULL: {
                result = "PullTaskExec";
                break;
            }
            case MACRO: {
                result = "MacroTaskExec";
                break;
            }
        }
        return result;
    }

    public Class<? extends TaskExec<?>> getTaskExecEntity() {
        Class result = null;
        switch (this.type) {
            case NOTIFICATION: {
                result = JPANotificationTaskExec.class;
                break;
            }
            case PROPAGATION: {
                result = JPAPropagationTaskExec.class;
                break;
            }
            case SCHEDULED: {
                result = JPASchedTaskExec.class;
                break;
            }
            case PUSH: {
                result = JPAPushTaskExec.class;
                break;
            }
            case LIVE_SYNC: {
                result = JPALiveSyncTaskExec.class;
                break;
            }
            case PULL: {
                result = JPAPullTaskExec.class;
                break;
            }
            case MACRO: {
                result = JPAMacroTaskExec.class;
                break;
            }
        }
        return result;
    }
}

