/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity.task;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.task.FormPropertyDef;
import org.apache.syncope.core.persistence.api.entity.task.MacroTask;
import org.apache.syncope.core.persistence.api.entity.task.MacroTaskCommand;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.jpa.entity.JPAImplementation;
import org.apache.syncope.core.persistence.jpa.entity.JPARealm;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAFormPropertyDef;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAMacroTaskCommand;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAMacroTaskExec;
import org.apache.syncope.core.persistence.jpa.entity.task.JPASchedTask;

@Entity
@Table(name="MacroTask")
public class JPAMacroTask
extends JPASchedTask
implements MacroTask,
PersistenceCapable {
    private static final long serialVersionUID = 8261850094316787406L;
    public static final String TABLE = "MacroTask";
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    private JPARealm realm;
    @NotNull
    private Boolean continueOnError = false;
    @NotNull
    private Boolean saveExecs = true;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, orphanRemoval=true, mappedBy="macroTask")
    @OrderBy(value="idx")
    private List<JPAMacroTaskCommand> macroTaskCommands = new ArrayList<JPAMacroTaskCommand>();
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, orphanRemoval=true, mappedBy="macroTask")
    @OrderBy(value="idx")
    @Valid
    private List<JPAFormPropertyDef> formPropertyDefs = new ArrayList<JPAFormPropertyDef>();
    @ManyToOne(fetch=FetchType.EAGER)
    private JPAImplementation macroActions;
    @OneToMany(targetEntity=JPAMacroTaskExec.class, cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="task")
    private List<TaskExec<SchedTask>> executions = new ArrayList<TaskExec<SchedTask>>();
    private static int pcInheritedFieldCount = JPASchedTask.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;

    public Realm getRealm() {
        return JPAMacroTask.pcGetrealm(this);
    }

    public void setRealm(Realm realm) {
        this.checkType(realm, JPARealm.class);
        JPAMacroTask.pcSetrealm(this, (JPARealm)realm);
    }

    public boolean isContinueOnError() {
        return JPAMacroTask.pcGetcontinueOnError(this) == null ? false : JPAMacroTask.pcGetcontinueOnError(this);
    }

    public void setContinueOnError(boolean continueOnError) {
        JPAMacroTask.pcSetcontinueOnError(this, continueOnError);
    }

    public boolean isSaveExecs() {
        return JPAMacroTask.pcGetsaveExecs(this) == null ? true : JPAMacroTask.pcGetsaveExecs(this);
    }

    public void setSaveExecs(boolean saveExecs) {
        JPAMacroTask.pcSetsaveExecs(this, saveExecs);
    }

    @Override
    protected Class<? extends TaskExec<SchedTask>> executionClass() {
        return JPAMacroTaskExec.class;
    }

    @Override
    protected List<TaskExec<SchedTask>> executions() {
        return JPAMacroTask.pcGetexecutions(this);
    }

    public void add(MacroTaskCommand macroTaskCommand) {
        this.checkType(macroTaskCommand, JPAMacroTaskCommand.class);
        ((JPAMacroTaskCommand)macroTaskCommand).setIdx(JPAMacroTask.pcGetmacroTaskCommands(this).size());
        JPAMacroTask.pcGetmacroTaskCommands(this).add((JPAMacroTaskCommand)macroTaskCommand);
    }

    public List<? extends MacroTaskCommand> getCommands() {
        return JPAMacroTask.pcGetmacroTaskCommands(this);
    }

    public void add(FormPropertyDef formPropertyDef) {
        this.checkType(formPropertyDef, JPAFormPropertyDef.class);
        ((JPAFormPropertyDef)formPropertyDef).setIdx(JPAMacroTask.pcGetformPropertyDefs(this).size());
        JPAMacroTask.pcGetformPropertyDefs(this).add((JPAFormPropertyDef)formPropertyDef);
    }

    public List<? extends FormPropertyDef> getFormPropertyDefs() {
        return JPAMacroTask.pcGetformPropertyDefs(this);
    }

    public Implementation getMacroActions() {
        return JPAMacroTask.pcGetmacroActions(this);
    }

    public void setMacroAction(Implementation macroActions) {
        this.checkType(macroActions, JPAImplementation.class);
        this.checkImplementationType(macroActions, "MACRO_ACTIONS");
        JPAMacroTask.pcSetmacroActions(this, (JPAImplementation)macroActions);
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 255933283;
    }

    static {
        pcPCSuperclass = JPASchedTask.class;
        pcFieldNames = new String[]{"continueOnError", "executions", "formPropertyDefs", "macroActions", "macroTaskCommands", "realm", "saveExecs"};
        pcFieldTypes = new Class[]{Boolean.class, List.class, List.class, JPAImplementation.class, List.class, JPARealm.class, Boolean.class};
        pcFieldFlags = new byte[]{26, 5, 10, 26, 10, 26, 26};
        PCRegistry.register(JPAMacroTask.class, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JPAMacroTask", (PersistenceCapable)new JPAMacroTask());
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.continueOnError = null;
        this.executions = null;
        this.formPropertyDefs = null;
        this.macroActions = null;
        this.macroTaskCommands = null;
        this.realm = null;
        this.saveExecs = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPAMacroTask jPAMacroTask = new JPAMacroTask();
        if (bl) {
            jPAMacroTask.pcClearFields();
        }
        jPAMacroTask.pcStateManager = stateManager;
        jPAMacroTask.pcCopyKeyFieldsFromObjectId(object);
        return jPAMacroTask;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPAMacroTask jPAMacroTask = new JPAMacroTask();
        if (bl) {
            jPAMacroTask.pcClearFields();
        }
        jPAMacroTask.pcStateManager = stateManager;
        return jPAMacroTask;
    }

    protected static int pcGetManagedFieldCount() {
        return 7 + JPASchedTask.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.continueOnError = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.executions = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.formPropertyDefs = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.macroActions = (JPAImplementation)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.macroTaskCommands = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.realm = (JPARealm)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.saveExecs = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcReplaceField(nArray[i]);
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.continueOnError);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.executions);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.formPropertyDefs);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.macroActions);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.macroTaskCommands);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.realm);
                return;
            }
            case 6: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.saveExecs);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcProvideField(nArray[i]);
        }
    }

    protected void pcCopyField(JPAMacroTask jPAMacroTask, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPAMacroTask, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.continueOnError = jPAMacroTask.continueOnError;
                return;
            }
            case 1: {
                this.executions = jPAMacroTask.executions;
                return;
            }
            case 2: {
                this.formPropertyDefs = jPAMacroTask.formPropertyDefs;
                return;
            }
            case 3: {
                this.macroActions = jPAMacroTask.macroActions;
                return;
            }
            case 4: {
                this.macroTaskCommands = jPAMacroTask.macroTaskCommands;
                return;
            }
            case 5: {
                this.realm = jPAMacroTask.realm;
                return;
            }
            case 6: {
                this.saveExecs = jPAMacroTask.saveExecs;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPAMacroTask jPAMacroTask = (JPAMacroTask)object;
        if (jPAMacroTask.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.pcCopyField(jPAMacroTask, nArray[i]);
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        return JPAMacroTask.class;
    }

    private static final Boolean pcGetcontinueOnError(JPAMacroTask jPAMacroTask) {
        if (jPAMacroTask.pcStateManager == null) {
            return jPAMacroTask.continueOnError;
        }
        int n = pcInheritedFieldCount + 0;
        jPAMacroTask.pcStateManager.accessingField(n);
        return jPAMacroTask.continueOnError;
    }

    private static final void pcSetcontinueOnError(JPAMacroTask jPAMacroTask, Boolean bl) {
        if (jPAMacroTask.pcStateManager == null) {
            jPAMacroTask.continueOnError = bl;
            return;
        }
        jPAMacroTask.pcStateManager.settingObjectField((PersistenceCapable)jPAMacroTask, pcInheritedFieldCount + 0, (Object)jPAMacroTask.continueOnError, (Object)bl, 0);
    }

    private static final List pcGetexecutions(JPAMacroTask jPAMacroTask) {
        if (jPAMacroTask.pcStateManager == null) {
            return jPAMacroTask.executions;
        }
        int n = pcInheritedFieldCount + 1;
        jPAMacroTask.pcStateManager.accessingField(n);
        return jPAMacroTask.executions;
    }

    private static final void pcSetexecutions(JPAMacroTask jPAMacroTask, List list) {
        if (jPAMacroTask.pcStateManager == null) {
            jPAMacroTask.executions = list;
            return;
        }
        jPAMacroTask.pcStateManager.settingObjectField((PersistenceCapable)jPAMacroTask, pcInheritedFieldCount + 1, jPAMacroTask.executions, (Object)list, 0);
    }

    private static final List pcGetformPropertyDefs(JPAMacroTask jPAMacroTask) {
        if (jPAMacroTask.pcStateManager == null) {
            return jPAMacroTask.formPropertyDefs;
        }
        int n = pcInheritedFieldCount + 2;
        jPAMacroTask.pcStateManager.accessingField(n);
        return jPAMacroTask.formPropertyDefs;
    }

    private static final void pcSetformPropertyDefs(JPAMacroTask jPAMacroTask, List list) {
        if (jPAMacroTask.pcStateManager == null) {
            jPAMacroTask.formPropertyDefs = list;
            return;
        }
        jPAMacroTask.pcStateManager.settingObjectField((PersistenceCapable)jPAMacroTask, pcInheritedFieldCount + 2, jPAMacroTask.formPropertyDefs, (Object)list, 0);
    }

    private static final JPAImplementation pcGetmacroActions(JPAMacroTask jPAMacroTask) {
        if (jPAMacroTask.pcStateManager == null) {
            return jPAMacroTask.macroActions;
        }
        int n = pcInheritedFieldCount + 3;
        jPAMacroTask.pcStateManager.accessingField(n);
        return jPAMacroTask.macroActions;
    }

    private static final void pcSetmacroActions(JPAMacroTask jPAMacroTask, JPAImplementation jPAImplementation) {
        if (jPAMacroTask.pcStateManager == null) {
            jPAMacroTask.macroActions = jPAImplementation;
            return;
        }
        jPAMacroTask.pcStateManager.settingObjectField((PersistenceCapable)jPAMacroTask, pcInheritedFieldCount + 3, (Object)jPAMacroTask.macroActions, (Object)jPAImplementation, 0);
    }

    private static final List pcGetmacroTaskCommands(JPAMacroTask jPAMacroTask) {
        if (jPAMacroTask.pcStateManager == null) {
            return jPAMacroTask.macroTaskCommands;
        }
        int n = pcInheritedFieldCount + 4;
        jPAMacroTask.pcStateManager.accessingField(n);
        return jPAMacroTask.macroTaskCommands;
    }

    private static final void pcSetmacroTaskCommands(JPAMacroTask jPAMacroTask, List list) {
        if (jPAMacroTask.pcStateManager == null) {
            jPAMacroTask.macroTaskCommands = list;
            return;
        }
        jPAMacroTask.pcStateManager.settingObjectField((PersistenceCapable)jPAMacroTask, pcInheritedFieldCount + 4, jPAMacroTask.macroTaskCommands, (Object)list, 0);
    }

    private static final JPARealm pcGetrealm(JPAMacroTask jPAMacroTask) {
        if (jPAMacroTask.pcStateManager == null) {
            return jPAMacroTask.realm;
        }
        int n = pcInheritedFieldCount + 5;
        jPAMacroTask.pcStateManager.accessingField(n);
        return jPAMacroTask.realm;
    }

    private static final void pcSetrealm(JPAMacroTask jPAMacroTask, JPARealm jPARealm) {
        if (jPAMacroTask.pcStateManager == null) {
            jPAMacroTask.realm = jPARealm;
            return;
        }
        jPAMacroTask.pcStateManager.settingObjectField((PersistenceCapable)jPAMacroTask, pcInheritedFieldCount + 5, (Object)jPAMacroTask.realm, (Object)jPARealm, 0);
    }

    private static final Boolean pcGetsaveExecs(JPAMacroTask jPAMacroTask) {
        if (jPAMacroTask.pcStateManager == null) {
            return jPAMacroTask.saveExecs;
        }
        int n = pcInheritedFieldCount + 6;
        jPAMacroTask.pcStateManager.accessingField(n);
        return jPAMacroTask.saveExecs;
    }

    private static final void pcSetsaveExecs(JPAMacroTask jPAMacroTask, Boolean bl) {
        if (jPAMacroTask.pcStateManager == null) {
            jPAMacroTask.saveExecs = bl;
            return;
        }
        jPAMacroTask.pcStateManager.settingObjectField((PersistenceCapable)jPAMacroTask, pcInheritedFieldCount + 6, (Object)jPAMacroTask.saveExecs, (Object)bl, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

