/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity.group;

import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.group.TypeExtension;
import org.apache.syncope.core.persistence.jpa.entity.AbstractGeneratedKeyEntity;
import org.apache.syncope.core.persistence.jpa.entity.JPAAnyType;
import org.apache.syncope.core.persistence.jpa.entity.JPAAnyTypeClass;
import org.apache.syncope.core.persistence.jpa.entity.group.JPAGroup;

@Entity
@Table(name="TypeExtension", uniqueConstraints={@UniqueConstraint(columnNames={"group_id", "anyType_id"})})
public class JPATypeExtension
extends AbstractGeneratedKeyEntity
implements TypeExtension,
PersistenceCapable {
    private static final long serialVersionUID = -8367626793791263551L;
    public static final String TABLE = "TypeExtension";
    @ManyToOne
    private JPAGroup group;
    @ManyToOne
    private JPAAnyType anyType;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(joinColumns={@JoinColumn(name="typeExtension_id")}, inverseJoinColumns={@JoinColumn(name="anyTypeClass_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"typeExtension_id", "anyTypeClass_id"})})
    private List<JPAAnyTypeClass> auxClasses = new ArrayList<JPAAnyTypeClass>();
    private static int pcInheritedFieldCount = AbstractGeneratedKeyEntity.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;

    public Group getGroup() {
        return JPATypeExtension.pcGetgroup(this);
    }

    public void setGroup(Group group) {
        this.checkType(group, JPAGroup.class);
        JPATypeExtension.pcSetgroup(this, (JPAGroup)group);
    }

    public AnyType getAnyType() {
        return JPATypeExtension.pcGetanyType(this);
    }

    public void setAnyType(AnyType anyType) {
        this.checkType(anyType, JPAAnyType.class);
        JPATypeExtension.pcSetanyType(this, (JPAAnyType)anyType);
    }

    public boolean add(AnyTypeClass auxClass) {
        this.checkType(auxClass, JPAAnyTypeClass.class);
        return JPATypeExtension.pcGetauxClasses(this).contains((JPAAnyTypeClass)auxClass) || JPATypeExtension.pcGetauxClasses(this).add((JPAAnyTypeClass)auxClass);
    }

    public List<? extends AnyTypeClass> getAuxClasses() {
        return JPATypeExtension.pcGetauxClasses(this);
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 255933283;
    }

    static {
        pcPCSuperclass = AbstractGeneratedKeyEntity.class;
        pcFieldNames = new String[]{"anyType", "auxClasses", "group"};
        pcFieldTypes = new Class[]{JPAAnyType.class, List.class, JPAGroup.class};
        pcFieldFlags = new byte[]{26, 10, 26};
        PCRegistry.register(JPATypeExtension.class, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JPATypeExtension", (PersistenceCapable)new JPATypeExtension());
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.anyType = null;
        this.auxClasses = null;
        this.group = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPATypeExtension jPATypeExtension = new JPATypeExtension();
        if (bl) {
            jPATypeExtension.pcClearFields();
        }
        jPATypeExtension.pcStateManager = stateManager;
        jPATypeExtension.pcCopyKeyFieldsFromObjectId(object);
        return jPATypeExtension;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPATypeExtension jPATypeExtension = new JPATypeExtension();
        if (bl) {
            jPATypeExtension.pcClearFields();
        }
        jPATypeExtension.pcStateManager = stateManager;
        return jPATypeExtension;
    }

    protected static int pcGetManagedFieldCount() {
        return 3 + AbstractGeneratedKeyEntity.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.anyType = (JPAAnyType)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.auxClasses = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.group = (JPAGroup)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcReplaceField(nArray[i]);
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.anyType);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.auxClasses);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.group);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcProvideField(nArray[i]);
        }
    }

    protected void pcCopyField(JPATypeExtension jPATypeExtension, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPATypeExtension, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.anyType = jPATypeExtension.anyType;
                return;
            }
            case 1: {
                this.auxClasses = jPATypeExtension.auxClasses;
                return;
            }
            case 2: {
                this.group = jPATypeExtension.group;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPATypeExtension jPATypeExtension = (JPATypeExtension)object;
        if (jPATypeExtension.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.pcCopyField(jPATypeExtension, nArray[i]);
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        return JPATypeExtension.class;
    }

    private static final JPAAnyType pcGetanyType(JPATypeExtension jPATypeExtension) {
        if (jPATypeExtension.pcStateManager == null) {
            return jPATypeExtension.anyType;
        }
        int n = pcInheritedFieldCount + 0;
        jPATypeExtension.pcStateManager.accessingField(n);
        return jPATypeExtension.anyType;
    }

    private static final void pcSetanyType(JPATypeExtension jPATypeExtension, JPAAnyType jPAAnyType) {
        if (jPATypeExtension.pcStateManager == null) {
            jPATypeExtension.anyType = jPAAnyType;
            return;
        }
        jPATypeExtension.pcStateManager.settingObjectField((PersistenceCapable)jPATypeExtension, pcInheritedFieldCount + 0, (Object)jPATypeExtension.anyType, (Object)jPAAnyType, 0);
    }

    private static final List pcGetauxClasses(JPATypeExtension jPATypeExtension) {
        if (jPATypeExtension.pcStateManager == null) {
            return jPATypeExtension.auxClasses;
        }
        int n = pcInheritedFieldCount + 1;
        jPATypeExtension.pcStateManager.accessingField(n);
        return jPATypeExtension.auxClasses;
    }

    private static final void pcSetauxClasses(JPATypeExtension jPATypeExtension, List list) {
        if (jPATypeExtension.pcStateManager == null) {
            jPATypeExtension.auxClasses = list;
            return;
        }
        jPATypeExtension.pcStateManager.settingObjectField((PersistenceCapable)jPATypeExtension, pcInheritedFieldCount + 1, jPATypeExtension.auxClasses, (Object)list, 0);
    }

    private static final JPAGroup pcGetgroup(JPATypeExtension jPATypeExtension) {
        if (jPATypeExtension.pcStateManager == null) {
            return jPATypeExtension.group;
        }
        int n = pcInheritedFieldCount + 2;
        jPATypeExtension.pcStateManager.accessingField(n);
        return jPATypeExtension.group;
    }

    private static final void pcSetgroup(JPATypeExtension jPATypeExtension, JPAGroup jPAGroup) {
        if (jPATypeExtension.pcStateManager == null) {
            jPATypeExtension.group = jPAGroup;
            return;
        }
        jPATypeExtension.pcStateManager.settingObjectField((PersistenceCapable)jPATypeExtension, pcInheritedFieldCount + 2, (Object)jPATypeExtension.group, (Object)jPAGroup, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

