/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao.repo;

import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.List;
import java.util.Set;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.entity.ConnInstance;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.jpa.dao.repo.ConnInstanceRepoExt;
import org.apache.syncope.core.persistence.jpa.entity.JPAConnInstance;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.DelegatedAdministrationException;
import org.springframework.transaction.annotation.Transactional;

public class ConnInstanceRepoExtImpl
implements ConnInstanceRepoExt {
    protected final ExternalResourceDAO resourceDAO;
    protected final EntityManager entityManager;

    public ConnInstanceRepoExtImpl(ExternalResourceDAO resourceDAO, EntityManager entityManager) {
        this.resourceDAO = resourceDAO;
        this.entityManager = entityManager;
    }

    @Override
    @Transactional(readOnly=true)
    public ConnInstance authFind(String key) {
        ConnInstance connInstance = (ConnInstance)this.entityManager.find(JPAConnInstance.class, (Object)key);
        if (connInstance == null) {
            return null;
        }
        Set authRealms = (Set)AuthContextUtils.getAuthorizations().get("CONNECTOR_READ");
        if (authRealms == null || authRealms.isEmpty() || authRealms.stream().noneMatch(realm -> connInstance.getAdminRealm().getFullPath().startsWith((String)realm))) {
            throw new DelegatedAdministrationException(connInstance.getAdminRealm().getFullPath(), ConnInstance.class.getSimpleName(), connInstance.getKey());
        }
        return connInstance;
    }

    @Override
    public List<? extends ConnInstance> findAll() {
        Set authRealms = (Set)AuthContextUtils.getAuthorizations().get("CONNECTOR_LIST");
        if (authRealms == null || authRealms.isEmpty()) {
            return List.of();
        }
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPAConnInstance.class.getSimpleName() + " e", ConnInstance.class);
        return query.getResultList().stream().filter(connInstance -> authRealms.stream().anyMatch(realm -> connInstance.getAdminRealm().getFullPath().startsWith((String)realm))).toList();
    }

    @Override
    public ConnInstance save(ConnInstance connector) {
        ((JPAConnInstance)connector).list2json();
        return (ConnInstance)this.entityManager.merge((Object)connector);
    }

    @Override
    public void deleteById(String key) {
        ConnInstance connInstance = (ConnInstance)this.entityManager.find(JPAConnInstance.class, (Object)key);
        if (connInstance == null) {
            return;
        }
        connInstance.getResources().stream().map(Entity::getKey).toList().forEach(arg_0 -> ((ExternalResourceDAO)this.resourceDAO).deleteById(arg_0));
        this.entityManager.remove((Object)connInstance);
    }
}

