/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;
import org.apache.syncope.core.persistence.api.dao.BatchDAO;
import org.apache.syncope.core.persistence.api.entity.Batch;
import org.apache.syncope.core.persistence.jpa.entity.JPABatch;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Throwable.class})
public class JPABatchDAO
implements BatchDAO {
    protected final EntityManager entityManager;

    public JPABatchDAO(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Transactional(readOnly=true)
    public boolean existsById(String key) {
        return this.findById(key).isPresent();
    }

    @Transactional(readOnly=true)
    public Optional<Batch> findById(String key) {
        return Optional.ofNullable((Batch)this.entityManager.find(JPABatch.class, (Object)key));
    }

    @Transactional(readOnly=true)
    public long count() {
        Query query = this.entityManager.createQuery("SELECT COUNT(e) FROM " + JPABatch.class.getSimpleName() + " e");
        return ((Number)query.getSingleResult()).longValue();
    }

    @Transactional(readOnly=true)
    public List<? extends Batch> findAll() {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPABatch.class.getSimpleName() + " e", Batch.class);
        return query.getResultList();
    }

    public <S extends Batch> S save(S batch) {
        return (S)((Batch)this.entityManager.merge(batch));
    }

    public void delete(Batch batch) {
        this.entityManager.remove((Object)batch);
    }

    public void deleteById(String key) {
        this.findById(key).ifPresent(this::delete);
    }

    public long deleteExpired() {
        Query query = this.entityManager.createQuery("DELETE FROM " + JPABatch.class.getSimpleName() + " e WHERE e.expiryTime < :now");
        query.setParameter("now", (Object)OffsetDateTime.now());
        return query.executeUpdate();
    }
}

