/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.trusted.authentication.storage;

import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.model.support.mfa.trusteddevice.TrustedDevicesMultifactorProperties;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustRecord;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustRecordKeyGenerator;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustStorage;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.inspektr.audit.annotation.Audit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.Transactional;

@EnableTransactionManagement(proxyTargetClass=false)
@Transactional(transactionManager="transactionManagerMfaAuthnTrust")
public abstract class BaseMultifactorAuthenticationTrustStorage
implements MultifactorAuthenticationTrustStorage {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseMultifactorAuthenticationTrustStorage.class);
    private final TrustedDevicesMultifactorProperties trustedDevicesMultifactorProperties;
    private final CipherExecutor<Serializable, String> cipherExecutor;
    private final MultifactorAuthenticationTrustRecordKeyGenerator keyGenerationStrategy;

    @Override
    @Audit(action="TRUSTED_AUTHENTICATION", actionResolverName="TRUSTED_AUTHENTICATION_ACTION_RESOLVER", resourceResolverName="TRUSTED_AUTHENTICATION_RESOURCE_RESOLVER")
    public MultifactorAuthenticationTrustRecord save(MultifactorAuthenticationTrustRecord record) {
        if (StringUtils.isBlank((CharSequence)record.getRecordKey())) {
            LOGGER.trace("Generating record key for record [{}]", (Object)record.getId());
            record.setRecordKey(this.generateKey(record));
        }
        LOGGER.debug("Storing authentication trust record for [{}]", (Object)record);
        return this.saveInternal(record);
    }

    @Override
    public Set<? extends MultifactorAuthenticationTrustRecord> get(String principal, ZonedDateTime onOrAfterDate) {
        Set<? extends MultifactorAuthenticationTrustRecord> res = this.get(principal);
        res.removeIf(entry -> {
            if (entry.getRecordDate().isBefore(onOrAfterDate)) {
                return true;
            }
            String decodedKey = (String)this.cipherExecutor.decode((Object)entry.getRecordKey());
            String currentKey = this.keyGenerationStrategy.generate((MultifactorAuthenticationTrustRecord)entry);
            return StringUtils.isBlank((CharSequence)decodedKey) || !decodedKey.equals(currentKey);
        });
        return res;
    }

    protected String generateKey(MultifactorAuthenticationTrustRecord r) {
        String key = this.keyGenerationStrategy.generate(r);
        return (String)this.cipherExecutor.encode((Object)key);
    }

    protected abstract MultifactorAuthenticationTrustRecord saveInternal(MultifactorAuthenticationTrustRecord var1);

    @Generated
    public String toString() {
        return "BaseMultifactorAuthenticationTrustStorage(trustedDevicesMultifactorProperties=" + String.valueOf(this.trustedDevicesMultifactorProperties) + ", cipherExecutor=" + String.valueOf(this.cipherExecutor) + ", keyGenerationStrategy=" + String.valueOf(this.keyGenerationStrategy) + ")";
    }

    @Generated
    protected BaseMultifactorAuthenticationTrustStorage(TrustedDevicesMultifactorProperties trustedDevicesMultifactorProperties, CipherExecutor<Serializable, String> cipherExecutor, MultifactorAuthenticationTrustRecordKeyGenerator keyGenerationStrategy) {
        this.trustedDevicesMultifactorProperties = trustedDevicesMultifactorProperties;
        this.cipherExecutor = cipherExecutor;
        this.keyGenerationStrategy = keyGenerationStrategy;
    }

    @Generated
    public TrustedDevicesMultifactorProperties getTrustedDevicesMultifactorProperties() {
        return this.trustedDevicesMultifactorProperties;
    }

    @Override
    @Generated
    public CipherExecutor<Serializable, String> getCipherExecutor() {
        return this.cipherExecutor;
    }

    @Generated
    public MultifactorAuthenticationTrustRecordKeyGenerator getKeyGenerationStrategy() {
        return this.keyGenerationStrategy;
    }
}

