/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.apache.kafka.raft.ElectionState;
import org.apache.kafka.raft.EpochState;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.internals.ReplicaKey;
import org.slf4j.Logger;

public class UnattachedState
implements EpochState {
    private final int epoch;
    private final Set<Integer> voters;
    private final long electionTimeoutMs;
    private final Timer electionTimer;
    private final Optional<LogOffsetMetadata> highWatermark;
    private final Logger log;

    public UnattachedState(Time time, int epoch, Set<Integer> voters, Optional<LogOffsetMetadata> highWatermark, long electionTimeoutMs, LogContext logContext) {
        this.epoch = epoch;
        this.voters = voters;
        this.highWatermark = highWatermark;
        this.electionTimeoutMs = electionTimeoutMs;
        this.electionTimer = time.timer(electionTimeoutMs);
        this.log = logContext.logger(UnattachedState.class);
    }

    @Override
    public ElectionState election() {
        return ElectionState.withUnknownLeader(this.epoch, this.voters);
    }

    @Override
    public int epoch() {
        return this.epoch;
    }

    @Override
    public String name() {
        return "Unattached";
    }

    public long electionTimeoutMs() {
        return this.electionTimeoutMs;
    }

    public long remainingElectionTimeMs(long currentTimeMs) {
        this.electionTimer.update(currentTimeMs);
        return this.electionTimer.remainingMs();
    }

    public boolean hasElectionTimeoutExpired(long currentTimeMs) {
        this.electionTimer.update(currentTimeMs);
        return this.electionTimer.isExpired();
    }

    @Override
    public Optional<LogOffsetMetadata> highWatermark() {
        return this.highWatermark;
    }

    @Override
    public boolean canGrantVote(ReplicaKey candidateKey, boolean isLogUpToDate) {
        if (!isLogUpToDate) {
            this.log.debug("Rejecting vote request from candidate ({}) since candidate epoch/offset is not up to date with us", (Object)candidateKey);
        }
        return isLogUpToDate;
    }

    public String toString() {
        return "Unattached(epoch=" + this.epoch + ", voters=" + this.voters + ", electionTimeoutMs=" + this.electionTimeoutMs + ')';
    }

    @Override
    public void close() {
    }
}

