/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.codec.StringDigester;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.storage.ReplayCache;
import org.opensaml.storage.StorageCapabilities;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageService;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class StorageServiceReplayCache
extends AbstractIdentifiableInitializableComponent
implements ReplayCache {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StorageServiceReplayCache.class);
    @NonnullAfterInit
    private StorageService storage;
    @NonnullAfterInit
    private StringDigester digester;
    private boolean strict;

    @NonnullAfterInit
    public StorageService getStorage() {
        return this.storage;
    }

    public void setStorage(@Nonnull StorageService storageService) {
        this.checkSetterPreconditions();
        this.storage = (StorageService)Constraint.isNotNull((Object)storageService, (String)"StorageService cannot be null");
        Constraint.isTrue((boolean)this.storage.getCapabilities().isServerSide(), (String)"StorageService cannot be client-side");
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean flag) {
        this.checkSetterPreconditions();
        this.strict = flag;
    }

    public void doInitialize() throws ComponentInitializationException {
        if (this.storage == null) {
            throw new ComponentInitializationException("StorageService cannot be null");
        }
        try {
            this.digester = new StringDigester("SHA", StringDigester.OutputFormat.HEX_LOWER);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ComponentInitializationException((Exception)e);
        }
    }

    public synchronized boolean check(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String s, @Nonnull Instant expires) {
        String key;
        StorageCapabilities caps = this.storage.getCapabilities();
        if (context.length() > caps.getContextSize()) {
            this.log.error("Context '{}' too long for StorageService (limit {})", (Object)context, (Object)caps.getContextSize());
            return false;
        }
        if (s.length() > caps.getKeySize()) {
            key = this.digester.apply(s);
            if (key == null) {
                this.log.error("Result of digesting key was null");
                return false;
            }
        } else {
            key = s;
        }
        try {
            StorageRecord entry = this.storage.read(context, key);
            if (entry == null) {
                this.log.debug("Value '{}' was not a replay, adding to cache with expiration time {}", (Object)s, (Object)expires);
                this.storage.create(context, key, "x", Long.valueOf(expires.toEpochMilli()));
                return true;
            }
            Long existingExp = entry.getExpiration();
            this.log.debug("Replay of value '{}' detected in cache, expires at {}", (Object)s, (Object)Instant.ofEpochMilli(existingExp != null ? existingExp : 0L));
            return false;
        }
        catch (IOException e) {
            this.log.error("Exception reading/writing to storage service, returning {}", (Object)(this.strict ? "failure" : "success"), (Object)e);
            return !this.strict;
        }
    }
}

