/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.rest;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class SRAStatistics
implements Serializable {
    private static final long serialVersionUID = 25070367703725L;
    private String name;
    private String description;
    private String baseUnit;
    private final List<Measurement> measurements = new ArrayList<Measurement>();
    private final List<Tag> availableTags = new ArrayList<Tag>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getBaseUnit() {
        return this.baseUnit;
    }

    public void setBaseUnit(String baseUnit) {
        this.baseUnit = baseUnit;
    }

    @JsonIgnore
    public Optional<Float> getMeasurement(String statistic) {
        return this.measurements.stream().filter(m -> statistic.equals(m.getStatistic())).findFirst().map(Measurement::getValue);
    }

    public List<Measurement> getMeasurements() {
        return this.measurements;
    }

    public List<Tag> getAvailableTags() {
        return this.availableTags;
    }

    public static class Measurement
    implements Serializable {
        private static final long serialVersionUID = 24933964529045L;
        private String statistic;
        private Float value;

        public String getStatistic() {
            return this.statistic;
        }

        public void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        public Float getValue() {
            return this.value;
        }

        public void setValue(Float value) {
            this.value = value;
        }
    }

    public static class Tag
    implements Serializable {
        private static final long serialVersionUID = 25010610267446L;
        private String tag;
        private final List<String> values = new ArrayList<String>();

        public String getTag() {
            return this.tag;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }

        public List<String> getValues() {
            return this.values;
        }
    }
}

