/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.flowable.support;

import java.util.List;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.flowable.common.engine.impl.db.ListQueryParameterObject;
import org.flowable.idm.api.Group;
import org.flowable.idm.engine.impl.GroupQueryImpl;
import org.flowable.idm.engine.impl.persistence.entity.GroupEntityImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class SyncopeGroupQueryImpl
extends GroupQueryImpl {
    private static final long serialVersionUID = -2595069675443343682L;
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private GroupDAO groupDAO;
    private List<Group> result;

    private static Group fromSyncopeGroup(String name) {
        GroupEntityImpl group = new GroupEntityImpl();
        group.setId(name);
        return group;
    }

    private void execute() {
        if (this.id != null) {
            this.result = this.groupDAO.findByName(this.id).map(group -> List.of(SyncopeGroupQueryImpl.fromSyncopeGroup(group.getName()))).orElseGet(List::of);
        } else if (this.userId != null) {
            this.result = this.userDAO.findByUsername(this.userId).map(user -> this.userDAO.findAllGroupNames(user).stream().map(SyncopeGroupQueryImpl::fromSyncopeGroup).toList()).orElseGet(List::of);
        }
    }

    @Transactional(readOnly=true)
    public long count() {
        this.checkQueryOk();
        this.resultType = ListQueryParameterObject.ResultType.COUNT;
        if (this.result == null) {
            this.execute();
        }
        return this.result.size();
    }

    @Transactional(readOnly=true)
    public List<Group> list() {
        this.checkQueryOk();
        this.resultType = ListQueryParameterObject.ResultType.LIST;
        if (this.result == null) {
            this.execute();
        }
        return this.result;
    }
}

