/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.flowable.impl;

import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.core.flowable.support.DomainProcessEngine;
import org.apache.syncope.core.persistence.api.attrvalue.InvalidEntityException;
import org.apache.syncope.core.persistence.api.attrvalue.ParsingValidationException;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.workflow.api.WorkflowException;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.engine.history.HistoricActivityInstance;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.Execution;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.identityconnectors.common.security.EncryptorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FlowableRuntimeUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FlowableRuntimeUtils.class);
    public static final String WF_PROCESS_ID = "userWorkflow";
    public static final String USER = "user";
    public static final String WF_EXECUTOR = "wfExecutor";
    public static final String FORM_SUBMITTER = "formSubmitter";
    public static final String USER_CR = "userCR";
    public static final String USER_TO = "userTO";
    public static final String ENABLED = "enabled";
    public static final String USER_UR = "userUR";
    public static final String TASK = "task";
    public static final String TOKEN = "token";
    public static final String PASSWORD = "password";
    public static final String PROP_BY_RESOURCE = "propByResource";
    public static final String PROP_BY_LINKEDACCOUNT = "propByLinkedAccount";
    public static final String PROPAGATE_ENABLE = "propagateEnable";
    public static final String ENCRYPTED_PWD = "encryptedPwd";
    public static final String EVENT = "event";

    public static String encrypt(String clear) {
        byte[] encrypted = EncryptorFactory.getInstance().getDefaultEncryptor().encrypt(clear.getBytes());
        return Base64.getEncoder().encodeToString(encrypted);
    }

    public static String decrypt(String crypted) {
        byte[] decrypted = EncryptorFactory.getInstance().getDefaultEncryptor().decrypt(Base64.getDecoder().decode(crypted));
        return new String(decrypted);
    }

    public static String getWFProcBusinessKey(String userKey) {
        return FlowableRuntimeUtils.getProcBusinessKey(WF_PROCESS_ID, userKey);
    }

    public static String getWFProcInstID(DomainProcessEngine engine, String userKey) {
        ProcessInstance procInst = (ProcessInstance)engine.getRuntimeService().createProcessInstanceQuery().processInstanceBusinessKey(FlowableRuntimeUtils.getWFProcBusinessKey(userKey)).singleResult();
        return Optional.ofNullable(procInst).map(Execution::getId).orElse(null);
    }

    public static String getProcBusinessKey(String procDefId, String userKey) {
        return procDefId + ":" + userKey;
    }

    public static Pair<String, String> splitProcBusinessKey(String procBusinessKey) {
        String[] split = procBusinessKey.split(":");
        if (split.length != 2) {
            throw new WorkflowException((Throwable)new IllegalArgumentException("Unexpected business key: " + procBusinessKey));
        }
        return Pair.of((Object)split[0], (Object)split[1]);
    }

    public static ProcessDefinition getLatestProcDefByKey(DomainProcessEngine engine, String key) {
        try {
            return (ProcessDefinition)engine.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey(key).latestVersion().singleResult();
        }
        catch (FlowableException e) {
            throw new WorkflowException("While accessing process " + key, (Throwable)e);
        }
    }

    public static Set<String> getPerformedTasks(DomainProcessEngine engine, String procInstId) {
        return engine.getHistoryService().createHistoricActivityInstanceQuery().executionId(procInstId).list().stream().map(HistoricActivityInstance::getActivityId).collect(Collectors.toSet());
    }

    public static void updateStatus(DomainProcessEngine engine, String procInstId, User user) {
        List tasks = ((TaskQuery)engine.getTaskService().createTaskQuery().processInstanceId(procInstId)).list();
        if (tasks.isEmpty() || tasks.size() > 1) {
            LOG.warn("While setting user status: unexpected task number ({})", (Object)tasks.size());
        } else {
            user.setStatus(((Task)tasks.getFirst()).getTaskDefinitionKey());
        }
    }

    public static String getFormTask(DomainProcessEngine engine, String procInstId) {
        String result = null;
        List tasks = ((TaskQuery)((TaskQuery)engine.getTaskService().createTaskQuery().taskWithFormKey()).processInstanceId(procInstId)).list();
        if (tasks.isEmpty() || tasks.size() > 1) {
            LOG.debug("While checking if form task: unexpected task number ({})", (Object)tasks.size());
        } else {
            result = ((Task)tasks.getFirst()).getFormKey();
        }
        return result;
    }

    public static void saveForFormSubmit(DomainProcessEngine engine, String procInstId, UserTO userTO, String password, Boolean enabled, PropagationByResource<String> propByRes, PropagationByResource<Pair<String, String>> propByLinkedAccount) {
        String formTaskId = FlowableRuntimeUtils.getFormTask(engine, procInstId);
        if (formTaskId == null) {
            return;
        }
        engine.getRuntimeService().setVariable(procInstId, USER_TO, (Object)userTO);
        if (password == null) {
            String encryptedPwd = (String)engine.getRuntimeService().getVariable(procInstId, ENCRYPTED_PWD, String.class);
            if (encryptedPwd != null) {
                userTO.setPassword(FlowableRuntimeUtils.decrypt(encryptedPwd));
            }
        } else {
            userTO.setPassword(password);
            engine.getRuntimeService().setVariable(procInstId, ENCRYPTED_PWD, (Object)FlowableRuntimeUtils.encrypt(password));
        }
        engine.getRuntimeService().setVariable(procInstId, ENABLED, (Object)enabled);
        engine.getRuntimeService().setVariable(procInstId, PROP_BY_RESOURCE, propByRes);
        if (propByRes != null) {
            propByRes.clear();
        }
        engine.getRuntimeService().setVariable(procInstId, PROP_BY_LINKEDACCOUNT, propByLinkedAccount);
        if (propByLinkedAccount != null) {
            propByLinkedAccount.clear();
        }
    }

    public static void throwException(FlowableException e, String defaultMessage) {
        if (e.getCause() == null) {
            throw new WorkflowException(defaultMessage, (Throwable)e);
        }
        Throwable throwable = e.getCause();
        if (throwable instanceof SyncopeClientException) {
            SyncopeClientException syncopeClientException = (SyncopeClientException)throwable;
            throw syncopeClientException;
        }
        throwable = e.getCause();
        if (throwable instanceof ParsingValidationException) {
            ParsingValidationException parsingValidationException = (ParsingValidationException)throwable;
            throw parsingValidationException;
        }
        throwable = e.getCause();
        if (throwable instanceof InvalidEntityException) {
            InvalidEntityException invalidEntityException = (InvalidEntityException)throwable;
            throw invalidEntityException;
        }
        if (e.getCause().getClass().getName().contains("persistence")) {
            throw (RuntimeException)e.getCause();
        }
        throw new WorkflowException(defaultMessage, (Throwable)e);
    }

    private FlowableRuntimeUtils() {
    }
}

