/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.http.common.api;

import org.flowable.http.common.api.HttpHeaders;

public class HttpResponse {
    protected int statusCode;
    protected String protocol;
    protected String reason;
    protected HttpHeaders httpHeaders;
    protected String body;
    protected byte[] bodyBytes;
    protected boolean bodyResponseHandled;

    public HttpResponse() {
    }

    public HttpResponse(int statusCode) {
        this(statusCode, null);
    }

    public HttpResponse(int statusCode, String headers) {
        this.statusCode = statusCode;
        this.httpHeaders = HttpHeaders.parseFromString(headers);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    public String getHttpHeadersAsString() {
        return this.httpHeaders != null ? this.httpHeaders.formatAsString() : null;
    }

    public void setHttpHeaders(HttpHeaders httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public byte[] getBodyBytes() {
        return this.bodyBytes;
    }

    public void setBodyBytes(byte[] bodyBytes) {
        this.bodyBytes = bodyBytes;
    }

    public boolean isBodyResponseHandled() {
        return this.bodyResponseHandled;
    }

    public void setBodyResponseHandled(boolean bodyResponseHandled) {
        this.bodyResponseHandled = bodyResponseHandled;
    }
}

