/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.mapping.results;

import org.springframework.binding.expression.EvaluationException;
import org.springframework.binding.expression.PropertyNotFoundException;
import org.springframework.binding.expression.ValueCoercionException;
import org.springframework.binding.mapping.Mapping;
import org.springframework.binding.mapping.results.AbstractMappingResult;

public class TargetAccessError
extends AbstractMappingResult {
    private Object originalValue;
    private EvaluationException cause;

    public TargetAccessError(Mapping mapping, Object originalValue, EvaluationException cause) {
        super(mapping);
        this.originalValue = originalValue;
        this.cause = cause;
    }

    @Override
    public String getCode() {
        if (this.cause instanceof PropertyNotFoundException) {
            return "propertyNotFound";
        }
        if (this.cause instanceof ValueCoercionException) {
            return "typeMismatch";
        }
        return "evaluationException";
    }

    @Override
    public boolean isError() {
        return true;
    }

    @Override
    public Throwable getErrorCause() {
        return this.cause;
    }

    @Override
    public Object getOriginalValue() {
        return this.originalValue;
    }

    @Override
    public Object getMappedValue() {
        return null;
    }
}

