/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.json;

import com.unboundid.ldap.sdk.unboundidds.controls.AssuredReplicationServerResultCode;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONFormattedAccessLogFields;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONObject;
import java.io.Serializable;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JSONAssuredReplicationServerResult
implements Serializable {
    private static final long serialVersionUID = 7810704048456207340L;
    @Nullable
    private final AssuredReplicationServerResultCode resultCode;
    @NotNull
    private final JSONObject serverResultObject;
    @Nullable
    private final Long replicaID;
    @Nullable
    private final Long replicationServerID;

    public JSONAssuredReplicationServerResult(@NotNull JSONObject serverResultObject) {
        this.serverResultObject = serverResultObject;
        this.replicaID = serverResultObject.getFieldAsLong(JSONFormattedAccessLogFields.SERVER_ASSURANCE_RESULTS_REPLICA_ID.getFieldName());
        this.replicationServerID = serverResultObject.getFieldAsLong(JSONFormattedAccessLogFields.SERVER_ASSURANCE_RESULTS_REPLICATION_SERVER_ID.getFieldName());
        String resultCodeName = serverResultObject.getFieldAsString(JSONFormattedAccessLogFields.SERVER_ASSURANCE_RESULTS_RESULT_CODE.getFieldName());
        this.resultCode = resultCodeName == null ? null : AssuredReplicationServerResultCode.forName(resultCodeName);
    }

    @NotNull
    public JSONObject getServerResultObject() {
        return this.serverResultObject;
    }

    @Nullable
    public AssuredReplicationServerResultCode getResultCode() {
        return this.resultCode;
    }

    @Nullable
    public Long getReplicationServerID() {
        return this.replicationServerID;
    }

    @Nullable
    public Long getReplicaID() {
        return this.replicaID;
    }

    @NotNull
    public String toString() {
        return this.serverResultObject.toSingleLineString();
    }
}

