/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ExcludeBranchRequestControl
extends Control {
    @NotNull
    public static final String EXCLUDE_BRANCH_REQUEST_OID = "1.3.6.1.4.1.30221.2.5.17";
    private static final byte TYPE_BASE_DNS = -96;
    @NotNull
    private static final String JSON_FIELD_BASE_DNS = "base-dns";
    private static final long serialVersionUID = -8599554860060612417L;
    @NotNull
    private final List<String> baseDNs;

    public ExcludeBranchRequestControl(@NotNull Collection<String> baseDNs) {
        this(true, baseDNs);
    }

    public ExcludeBranchRequestControl(String ... baseDNs) {
        this(true, baseDNs);
    }

    public ExcludeBranchRequestControl(boolean isCritical, String ... baseDNs) {
        super(EXCLUDE_BRANCH_REQUEST_OID, isCritical, ExcludeBranchRequestControl.encodeValue(baseDNs));
        this.baseDNs = Collections.unmodifiableList(Arrays.asList(baseDNs));
    }

    public ExcludeBranchRequestControl(boolean isCritical, @NotNull Collection<String> baseDNs) {
        super(EXCLUDE_BRANCH_REQUEST_OID, isCritical, ExcludeBranchRequestControl.encodeValue(baseDNs));
        this.baseDNs = Collections.unmodifiableList(new ArrayList<String>(baseDNs));
    }

    public ExcludeBranchRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        ASN1Sequence valueSequence;
        ASN1OctetString value = control.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_EXCLUDE_BRANCH_MISSING_VALUE.get());
        }
        try {
            valueSequence = ASN1Sequence.decodeAsSequence(value.getValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_EXCLUDE_BRANCH_VALUE_NOT_SEQUENCE.get(StaticUtils.getExceptionMessage(e)), e);
        }
        try {
            ASN1Element[] elements = valueSequence.elements();
            ASN1Element[] dnElements = ASN1Sequence.decodeAsSequence(elements[0]).elements();
            ArrayList<String> dnList = new ArrayList<String>(dnElements.length);
            for (ASN1Element e : dnElements) {
                dnList.add(ASN1OctetString.decodeAsOctetString(e).stringValue());
            }
            this.baseDNs = Collections.unmodifiableList(dnList);
            if (this.baseDNs.isEmpty()) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_EXCLUDE_BRANCH_NO_BASE_DNS.get());
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_EXCLUDE_BRANCH_ERROR_PARSING_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    private static ASN1OctetString encodeValue(String ... baseDNs) {
        Validator.ensureNotNull(baseDNs);
        return ExcludeBranchRequestControl.encodeValue(Arrays.asList(baseDNs));
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull Collection<String> baseDNs) {
        Validator.ensureNotNull(baseDNs);
        Validator.ensureFalse(baseDNs.isEmpty());
        ArrayList<ASN1OctetString> dnElements = new ArrayList<ASN1OctetString>(baseDNs.size());
        for (String s : baseDNs) {
            dnElements.add(new ASN1OctetString(s));
        }
        ASN1Sequence baseDNSequence = new ASN1Sequence(-96, dnElements);
        ASN1Sequence valueSequence = new ASN1Sequence(baseDNSequence);
        return new ASN1OctetString(valueSequence.encode());
    }

    @NotNull
    public List<String> getBaseDNs() {
        return this.baseDNs;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_EXCLUDE_BRANCH.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        ArrayList<JSONString> baseDNValues = new ArrayList<JSONString>(this.baseDNs.size());
        for (String baseDN : this.baseDNs) {
            baseDNValues.add(new JSONString(baseDN));
        }
        return new JSONObject(new JSONField("oid", EXCLUDE_BRANCH_REQUEST_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_EXCLUDE_BRANCH.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", new JSONObject(new JSONField(JSON_FIELD_BASE_DNS, new JSONArray(baseDNValues)))));
    }

    @NotNull
    public static ExcludeBranchRequestControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new ExcludeBranchRequestControl(new Control(jsonControl.getOID(), jsonControl.getCriticality(), rawValue));
        }
        JSONObject valueObject = jsonControl.getValueObject();
        List<JSONValue> baseDNValues = valueObject.getFieldAsArray(JSON_FIELD_BASE_DNS);
        if (baseDNValues == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_EXCLUDE_BRANCH_JSON_MISSING_BASE_DNS.get(controlObject.toSingleLineString(), JSON_FIELD_BASE_DNS));
        }
        if (baseDNValues.isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_EXCLUDE_BRANCH_JSON_EMPTY_BASE_DNS.get(controlObject.toSingleLineString()));
        }
        ArrayList<String> baseDNs = new ArrayList<String>(baseDNValues.size());
        for (JSONValue baseDNValue : baseDNValues) {
            if (baseDNValue instanceof JSONString) {
                baseDNs.add(((JSONString)baseDNValue).stringValue());
                continue;
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_EXCLUDE_BRANCH_JSON_BASE_DN_NOT_STRING.get(controlObject.toSingleLineString(), JSON_FIELD_BASE_DNS));
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_BASE_DNS)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_EXCLUDE_BRANCH_JSON_CONTROL_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new ExcludeBranchRequestControl(jsonControl.getCriticality(), baseDNs);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("ExcludeBranchRequestControl(isCritical=");
        buffer.append(this.isCritical());
        buffer.append(", baseDNs={");
        Iterator<String> iterator = this.baseDNs.iterator();
        while (iterator.hasNext()) {
            buffer.append('\'');
            buffer.append(iterator.next());
            buffer.append('\'');
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("})");
    }
}

