/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.UnboundIDDSMessages;
import com.unboundid.util.CryptoHelper;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.text.DecimalFormat;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class OneTimePassword {
    public static final int DEFAULT_HOTP_NUM_DIGITS = 6;
    public static final int DEFAULT_TOTP_INTERVAL_DURATION_SECONDS = 30;
    public static final int DEFAULT_TOTP_NUM_DIGITS = 6;
    @NotNull
    private static final String HMAC_ALGORITHM_SHA_1 = "HmacSHA1";
    @NotNull
    private static final String KEY_ALGORITHM_RAW = "RAW";

    private OneTimePassword() {
    }

    @NotNull
    public static String hotp(@NotNull byte[] sharedSecret, long counter) throws LDAPException {
        return OneTimePassword.hotp(sharedSecret, counter, 6);
    }

    @NotNull
    public static String hotp(@NotNull byte[] sharedSecret, long counter, int numDigits) throws LDAPException {
        try {
            DecimalFormat decimalFormat;
            int modulus;
            switch (numDigits) {
                case 6: {
                    modulus = 1000000;
                    decimalFormat = new DecimalFormat("000000");
                    break;
                }
                case 7: {
                    modulus = 10000000;
                    decimalFormat = new DecimalFormat("0000000");
                    break;
                }
                case 8: {
                    modulus = 100000000;
                    decimalFormat = new DecimalFormat("00000000");
                    break;
                }
                default: {
                    throw new LDAPException(ResultCode.PARAM_ERROR, UnboundIDDSMessages.ERR_HOTP_INVALID_NUM_DIGITS.get(numDigits));
                }
            }
            byte[] counterBytes = new byte[]{(byte)(counter >> 56 & 0xFFL), (byte)(counter >> 48 & 0xFFL), (byte)(counter >> 40 & 0xFFL), (byte)(counter >> 32 & 0xFFL), (byte)(counter >> 24 & 0xFFL), (byte)(counter >> 16 & 0xFFL), (byte)(counter >> 8 & 0xFFL), (byte)(counter & 0xFFL)};
            SecretKeySpec k = new SecretKeySpec(sharedSecret, KEY_ALGORITHM_RAW);
            Mac m = CryptoHelper.getMAC(HMAC_ALGORITHM_SHA_1);
            m.init(k);
            byte[] hmacBytes = m.doFinal(counterBytes);
            int dtOffset = hmacBytes[19] & 0xF;
            int dtValue = (hmacBytes[dtOffset] & 0x7F) << 24 | (hmacBytes[dtOffset + 1] & 0xFF) << 16 | (hmacBytes[dtOffset + 2] & 0xFF) << 8 | hmacBytes[dtOffset + 3] & 0xFF;
            return decimalFormat.format(dtValue % modulus);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, UnboundIDDSMessages.ERR_HOTP_ERROR_GENERATING_PW.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    public static String totp(@NotNull byte[] sharedSecret) throws LDAPException {
        return OneTimePassword.totp(sharedSecret, System.currentTimeMillis(), 30, 6);
    }

    @NotNull
    public static String totp(@NotNull byte[] sharedSecret, long authTime, int intervalDurationSeconds, int numDigits) throws LDAPException {
        if (numDigits < 6 || numDigits > 8) {
            throw new LDAPException(ResultCode.PARAM_ERROR, UnboundIDDSMessages.ERR_TOTP_INVALID_NUM_DIGITS.get(numDigits));
        }
        try {
            long timeIntervalNumber = authTime / 1000L / (long)intervalDurationSeconds;
            return OneTimePassword.hotp(sharedSecret, timeIntervalNumber, numDigits);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, UnboundIDDSMessages.ERR_TOTP_ERROR_GENERATING_PW.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }
}

