/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.mvc.view;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tiles.Attribute;
import org.apache.tiles.AttributeContext;
import org.apache.tiles.Definition;
import org.apache.tiles.access.TilesAccess;
import org.apache.tiles.impl.BasicTilesContainer;
import org.apache.tiles.request.ApplicationContext;
import org.apache.tiles.request.Request;
import org.apache.tiles.request.servlet.ServletRequest;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.support.JstlUtils;
import org.springframework.web.servlet.support.RequestContext;
import org.springframework.web.servlet.view.tiles3.TilesView;
import org.springframework.webflow.context.servlet.AjaxHandler;
import org.springframework.webflow.context.servlet.DefaultAjaxHandler;

public class AjaxTiles3View
extends TilesView {
    private static final String FRAGMENTS_PARAM = "fragments";
    private AjaxHandler ajaxHandler = new DefaultAjaxHandler();

    public AjaxHandler getAjaxHandler() {
        return this.ajaxHandler;
    }

    public void setAjaxHandler(AjaxHandler ajaxHandler) {
        this.ajaxHandler = ajaxHandler;
    }

    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServletContext servletContext = this.getServletContext();
        if (this.ajaxHandler.isAjaxRequest(request, response)) {
            String[] fragmentsToRender = this.getRenderFragments(model, request, response);
            if (fragmentsToRender.length == 0) {
                this.logger.warn((Object)"An Ajax request was detected, but no fragments were specified to be re-rendered.  Falling back to full page render.  This can cause unpredictable results when processing the ajax response on the client.");
                super.renderMergedOutputModel(model, request, response);
                return;
            }
            Request tilesRequest = this.createTilesRequest(request, response);
            ApplicationContext tilesAppContext = tilesRequest.getApplicationContext();
            BasicTilesContainer container = (BasicTilesContainer)TilesAccess.getContainer((ApplicationContext)tilesAppContext);
            if (container == null) {
                throw new ServletException("Tiles container is not initialized. Have you added a TilesConfigurer to your web application context?");
            }
            this.exposeModelAsRequestAttributes(model, request);
            JstlUtils.exposeLocalizationContext((RequestContext)new RequestContext(request, servletContext));
            Definition compositeDefinition = container.getDefinitionsFactory().getDefinition(this.getUrl(), tilesRequest);
            HashMap<String, Attribute> flattenedAttributeMap = new HashMap<String, Attribute>();
            this.flattenAttributeMap(container, tilesRequest, flattenedAttributeMap, compositeDefinition);
            this.addRuntimeAttributes(container, tilesRequest, flattenedAttributeMap);
            if (fragmentsToRender.length > 1) {
                tilesRequest.getContext("request").put(ServletRequest.FORCE_INCLUDE_ATTRIBUTE_NAME, true);
            }
            for (String element : fragmentsToRender) {
                Attribute attributeToRender = (Attribute)flattenedAttributeMap.get(element);
                if (attributeToRender == null) {
                    throw new ServletException("No tiles attribute with a name of '" + element + "' could be found for the current view: " + (Object)((Object)this));
                }
                container.startContext(tilesRequest).inheritCascadedAttributes((AttributeContext)compositeDefinition);
                container.render(attributeToRender, tilesRequest);
                container.endContext(tilesRequest);
            }
        } else {
            super.renderMergedOutputModel(model, request, response);
        }
    }

    protected String[] getRenderFragments(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) {
        String attrName = request.getParameter(FRAGMENTS_PARAM);
        String[] renderFragments = StringUtils.commaDelimitedListToStringArray((String)attrName);
        return StringUtils.trimArrayElements((String[])renderFragments);
    }

    protected void flattenAttributeMap(BasicTilesContainer container, Request tilesRequest, Map<String, Attribute> resultMap, Definition definition) {
        HashSet attributeNames = new HashSet();
        if (definition.getLocalAttributeNames() != null) {
            attributeNames.addAll(definition.getLocalAttributeNames());
        }
        if (definition.getCascadedAttributeNames() != null) {
            attributeNames.addAll(definition.getCascadedAttributeNames());
        }
        for (String attributeName : attributeNames) {
            Attribute attribute = definition.getAttribute(attributeName);
            if (attribute.getValue() == null || !(attribute.getValue() instanceof String)) continue;
            String value = attribute.getValue().toString();
            if (value.startsWith("/")) {
                resultMap.put(attributeName, attribute);
                continue;
            }
            if (!container.isValidDefinition(value, tilesRequest)) continue;
            resultMap.put(attributeName, attribute);
            Definition nestedDefinition = container.getDefinitionsFactory().getDefinition(value, tilesRequest);
            Assert.isTrue((nestedDefinition != definition ? 1 : 0) != 0, (String)("Circular nested definition: " + value));
            this.flattenAttributeMap(container, tilesRequest, resultMap, nestedDefinition);
        }
    }

    protected void addRuntimeAttributes(BasicTilesContainer container, Request tilesRequest, Map<String, Attribute> resultMap) {
        AttributeContext attributeContext = container.getAttributeContext(tilesRequest);
        HashSet attributeNames = new HashSet();
        if (attributeContext.getLocalAttributeNames() != null) {
            attributeNames.addAll(attributeContext.getLocalAttributeNames());
        }
        if (attributeContext.getCascadedAttributeNames() != null) {
            attributeNames.addAll(attributeContext.getCascadedAttributeNames());
        }
        for (String name : attributeNames) {
            Attribute attr = attributeContext.getAttribute(name);
            resultMap.put(name, attr);
        }
    }
}

