/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.cpp;

import com.google.gxp.com.google.common.base.Function;
import com.google.gxp.com.google.common.base.Join;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.ImmutableList;
import com.google.gxp.com.google.common.collect.Iterables;
import com.google.gxp.com.google.common.collect.Lists;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.alerts.common.NothingToCompileError;
import com.google.gxp.compiler.base.BooleanType;
import com.google.gxp.compiler.base.BundleType;
import com.google.gxp.compiler.base.ContentType;
import com.google.gxp.compiler.base.CppFileImport;
import com.google.gxp.compiler.base.CppLibraryImport;
import com.google.gxp.compiler.base.DefaultingImportVisitor;
import com.google.gxp.compiler.base.FormalTypeParameter;
import com.google.gxp.compiler.base.Import;
import com.google.gxp.compiler.base.ImportVisitor;
import com.google.gxp.compiler.base.InstanceType;
import com.google.gxp.compiler.base.Interface;
import com.google.gxp.compiler.base.NativeType;
import com.google.gxp.compiler.base.NullRoot;
import com.google.gxp.compiler.base.Parameter;
import com.google.gxp.compiler.base.Root;
import com.google.gxp.compiler.base.RootVisitor;
import com.google.gxp.compiler.base.Template;
import com.google.gxp.compiler.base.TemplateName;
import com.google.gxp.compiler.base.TemplateType;
import com.google.gxp.compiler.base.Tree;
import com.google.gxp.compiler.base.Type;
import com.google.gxp.compiler.base.TypeVisitor;
import com.google.gxp.compiler.codegen.BracesCodeGenerator;
import com.google.gxp.compiler.cpp.CppUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class BaseCppCodeGenerator<T extends Tree<Root>>
extends BracesCodeGenerator<T> {
    protected BaseCppCodeGenerator(T tree) {
        super(tree);
    }

    @Override
    public void generateCode(final Appendable appendable, final AlertSink alertSink) throws IOException {
        alertSink.addAll(this.tree.getAlerts());
        this.root.acceptVisitor(new RootVisitor<Void>(){

            @Override
            public Void visitInterface(Interface iface) {
                BaseCppCodeGenerator.this.createInterfaceWorker(appendable, alertSink, iface).run();
                return null;
            }

            @Override
            public Void visitNullRoot(NullRoot nullRoot) {
                alertSink.add(new NothingToCompileError(nullRoot.getSourcePosition()));
                return null;
            }

            @Override
            public Void visitTemplate(Template template) {
                BaseCppCodeGenerator.this.createTemplateWorker(appendable, alertSink, template).run();
                return null;
            }
        });
    }

    protected abstract InterfaceWorker createInterfaceWorker(Appendable var1, AlertSink var2, Interface var3);

    protected abstract TemplateWorker createTemplateWorker(Appendable var1, AlertSink var2, Template var3);

    protected static abstract class TemplateWorker
    extends Worker {
        protected final Template template;

        protected TemplateWorker(Appendable out, AlertSink alertSink, Template template) {
            super(out, alertSink);
            this.template = Preconditions.checkNotNull(template);
        }

        protected abstract void appendClass();

        public void run() {
            this.appendHeader(this.template);
            this.appendLine();
            this.appendClass();
            this.appendLine();
            this.appendFooter();
        }

        protected String getWriteMethodSignature(boolean outsideClass, boolean isStatic) {
            return this.getWriteMethodSignature("Appendable*", outsideClass, isStatic);
        }

        protected String getWriteMethodSignature(String outType, boolean outsideClass, boolean isStatic) {
            List<Parameter> params = isStatic ? this.template.getAllParameters() : this.template.getParameters();
            StringBuilder sb = new StringBuilder();
            if (isStatic) {
                if (!this.template.getFormalTypeParameters().isEmpty()) {
                    this.appendCppFormalTypeParameters(sb, true, this.template.getFormalTypeParameters());
                    sb.append("\n");
                }
                if (!outsideClass) {
                    sb.append("static ");
                }
            }
            sb.append("void ");
            if (outsideClass) {
                sb.append(this.getQualifiedClassName(this.template.getName()));
                sb.append("::");
            }
            sb.append("Write(");
            Join.join(sb, ", ", Iterables.concat(Collections.singleton(String.format(GXP_SIG, outType)), Iterables.transform(params, this.parameterToCallName)));
            sb.append(")");
            return sb.toString();
        }

        protected String getGetGxpClosureMethodSignature(boolean outsideClass, boolean isStatic) {
            List<Parameter> params = isStatic ? this.template.getAllParameters() : this.template.getParameters();
            StringBuilder sb = new StringBuilder();
            if (isStatic) {
                if (!this.template.getFormalTypeParameters().isEmpty()) {
                    this.appendCppFormalTypeParameters(sb, true, this.template.getFormalTypeParameters());
                    sb.append("\n");
                }
                if (!outsideClass) {
                    sb.append("static ");
                }
            }
            sb.append(this.toCppType(new ContentType(this.template.getSchema())));
            sb.append(" ");
            if (outsideClass) {
                sb.append(this.getQualifiedClassName(this.template.getName()));
                sb.append("::");
            }
            sb.append("GetGxpClosure(");
            Join.join(sb, ", ", Iterables.transform(params, this.parameterToCallName));
            sb.append(")");
            return sb.toString();
        }
    }

    protected static abstract class InterfaceWorker
    extends Worker {
        protected final Interface iface;

        protected InterfaceWorker(Appendable out, AlertSink alertSink, Interface iface) {
            super(out, alertSink);
            this.iface = Preconditions.checkNotNull(iface);
        }

        protected abstract void appendClass();

        public void run() {
            this.appendHeader(this.iface);
            this.appendLine();
            this.appendClass();
            this.appendLine();
            this.appendFooter();
        }
    }

    protected static abstract class Worker
    extends BracesCodeGenerator.Worker {
        private final ImportVisitor<Void> IMPORT_VISITOR = new DefaultingImportVisitor<Void>(){

            @Override
            public Void defaultVisitImport(Import imp) {
                return null;
            }

            @Override
            public Void visitCppFileImport(CppFileImport imp) {
                Worker.this.formatLine(imp.getSourcePosition(), "#include %s", new Object[]{imp.getTarget()});
                return null;
            }

            @Override
            public Void visitCppLibraryImport(CppLibraryImport imp) {
                Worker.this.formatLine(imp.getSourcePosition(), "#include %s", new Object[]{imp.getTarget()});
                return null;
            }
        };
        protected static final String GXP_OUT_VAR = "gxp_out";
        protected static final String GXP_CONTEXT_VAR = "gxp_context";
        protected static final String GXP_SIG = Join.join(", ", (Object)"%s gxp_out", "const GxpContext& gxp_context");
        protected static final String DEFAULT_GXP_OUT_TYPE = "Appendable*";
        protected List<ExtraOutType> extraOutTypes = ImmutableList.of(new ExtraOutType("string*", "StringAppendable"));
        protected Function<Parameter, String> parameterToCallName = new Function<Parameter, String>(){

            @Override
            public String apply(Parameter param) {
                StringBuilder sb = new StringBuilder();
                sb.append(Worker.this.toCppType(param.getType()));
                sb.append(" ");
                sb.append(param.getPrimaryName());
                return sb.toString();
            }
        };
        protected Function<Parameter, String> parameterToInitializer = new Function<Parameter, String>(){

            @Override
            public String apply(Parameter param) {
                return param.getPrimaryName() + "(" + param.getPrimaryName() + ")";
            }
        };

        protected Worker(Appendable out, AlertSink alertSink) {
            super(out, alertSink, "public:", "private:");
        }

        protected String getClassName(TemplateName name) {
            return name.getBaseName();
        }

        protected String getQualifiedClassName(TemplateName name) {
            return Join.join("::", name.toString().split("\\."));
        }

        private String getIfdefGuard(TemplateName templateName) {
            return templateName.toString().replace('.', '_').toUpperCase() + "_H__";
        }

        protected void appendIfdefGuardStart(Root root) {
            String ifdefGuard = this.getIfdefGuard(root.getName());
            this.formatLine("#ifndef %s", ifdefGuard);
            this.formatLine("#define %s", ifdefGuard);
        }

        protected void appendIfdefGuardEnd(Root root) {
            this.formatLine("#endif  // %s", this.getIfdefGuard(root.getName()));
        }

        protected void appendImports(Root root) {
            for (String string : root.getSchema().getCppImports()) {
                this.formatLine(root.getSourcePosition(), "#include \"%s\"", string);
            }
            for (Import import_ : root.getImports()) {
                import_.acceptVisitor(this.IMPORT_VISITOR);
            }
        }

        protected void appendImports(Root root, Set<TemplateName> extraIncludes) {
            this.appendImports(root);
            for (TemplateName extraInclude : extraIncludes) {
                this.formatLine("#include \"%s.h\"", extraInclude.toString().replace('.', '/'));
            }
        }

        protected void appendNamespacesOpen(TemplateName templateName) {
            for (String part : templateName.getPackageName().split("\\.")) {
                this.formatLine("namespace %s {", part);
            }
        }

        protected void appendNamespacesClose(TemplateName templateName) {
            for (String part : templateName.getPackageName().split("\\.")) {
                this.appendLine("}");
            }
        }

        protected String toCppType(Type type) {
            return type.acceptTypeVisitor(new TypeVisitor<String>(){

                @Override
                public String visitBooleanType(BooleanType type) {
                    return "bool";
                }

                @Override
                public String visitBundleType(BundleType type) {
                    return "int";
                }

                @Override
                public String visitContentType(ContentType type) {
                    return type.getSchema().getCppType() + "*";
                }

                @Override
                public String visitInstanceType(InstanceType type) {
                    return Worker.this.getClassName(type.getTemplateName()) + "::Interface";
                }

                @Override
                public String visitNativeType(NativeType type) {
                    return CppUtil.validateType(Worker.this.alertSink, type);
                }

                @Override
                public String visitTemplateType(TemplateType type) {
                    return Worker.this.getClassName(type.getTemplateName());
                }
            });
        }

        protected List<String> toBoundedTypeDecls(boolean isDeclaration, Iterable<FormalTypeParameter> formalTypeParameters) {
            ArrayList<String> result = Lists.newArrayList();
            for (FormalTypeParameter formalTypeParameter : formalTypeParameters) {
                if (isDeclaration) {
                    result.add("typename " + formalTypeParameter.getName());
                    continue;
                }
                result.add(formalTypeParameter.getName());
            }
            return result;
        }

        protected void appendCppFormalTypeParameters(StringBuilder sb, boolean isDeclaration, List<FormalTypeParameter> formalTypeParameters) {
            if (!formalTypeParameters.isEmpty()) {
                if (isDeclaration) {
                    sb.append("template");
                }
                sb.append("<");
                Join.join(sb, ", ", this.toBoundedTypeDecls(isDeclaration, formalTypeParameters));
                sb.append(">");
            }
        }

        protected void appendCppFormalTypeParameters(boolean isDeclaration, List<FormalTypeParameter> formalTypeParameters) {
            StringBuilder sb = new StringBuilder();
            this.appendCppFormalTypeParameters(sb, isDeclaration, formalTypeParameters);
            this.appendLine(sb.toString());
        }

        protected class ExtraOutType {
            private final String outType;
            private final String outWrapper;

            public ExtraOutType(String outType, String outWrapper) {
                this.outType = Preconditions.checkNotNull(outType);
                this.outWrapper = Preconditions.checkNotNull(outWrapper);
            }

            public String getOutType() {
                return this.outType;
            }

            public String getOutWrapper() {
                return this.outWrapper;
            }

            public String getGxpSig() {
                return String.format(GXP_SIG, this.outType);
            }
        }
    }
}

