/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.socket.nio.NioSocketChannel;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.DefaultThreadFactory;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public final class NettyRpcClientConfigHelper {
    public static final String EVENT_LOOP_CONFIG = "hbase.rpc.client.event-loop.config";
    public static final String HBASE_NETTY_EVENTLOOP_RPCCLIENT_THREADCOUNT_KEY = "hbase.netty.eventloop.rpcclient.thread.count";
    private static final String CONFIG_NAME = "global-event-loop";
    private static final Map<String, Pair<EventLoopGroup, Class<? extends Channel>>> EVENT_LOOP_CONFIG_MAP = new HashMap<String, Pair<EventLoopGroup, Class<? extends Channel>>>();
    private static volatile Pair<EventLoopGroup, Class<? extends Channel>> DEFAULT_EVENT_LOOP;

    private NettyRpcClientConfigHelper() {
    }

    public static void setEventLoopConfig(Configuration conf, EventLoopGroup group, Class<? extends Channel> channelClass) {
        Preconditions.checkNotNull((Object)group, (Object)"group is null");
        Preconditions.checkNotNull(channelClass, (Object)"channel class is null");
        conf.set(EVENT_LOOP_CONFIG, CONFIG_NAME);
        EVENT_LOOP_CONFIG_MAP.put(CONFIG_NAME, (Pair<EventLoopGroup, Class<? extends Channel>>)Pair.newPair((Object)group, channelClass));
    }

    public static void createEventLoopPerClient(Configuration conf) {
        conf.set(EVENT_LOOP_CONFIG, "");
        EVENT_LOOP_CONFIG_MAP.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Pair<EventLoopGroup, Class<? extends Channel>> getDefaultEventLoopConfig(Configuration conf) {
        Pair eventLoop = DEFAULT_EVENT_LOOP;
        if (eventLoop != null) {
            return eventLoop;
        }
        Class<NettyRpcClientConfigHelper> clazz = NettyRpcClientConfigHelper.class;
        synchronized (NettyRpcClientConfigHelper.class) {
            eventLoop = DEFAULT_EVENT_LOOP;
            if (eventLoop != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return eventLoop;
            }
            int threadCount = conf.getInt(HBASE_NETTY_EVENTLOOP_RPCCLIENT_THREADCOUNT_KEY, 0);
            DEFAULT_EVENT_LOOP = eventLoop = new Pair((Object)new NioEventLoopGroup(threadCount, (ThreadFactory)new DefaultThreadFactory("RPCClient-NioEventLoopGroup", true, 5)), NioSocketChannel.class);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return eventLoop;
        }
    }

    static Pair<EventLoopGroup, Class<? extends Channel>> getEventLoopConfig(Configuration conf) {
        String name = conf.get(EVENT_LOOP_CONFIG);
        if (name == null) {
            return NettyRpcClientConfigHelper.getDefaultEventLoopConfig(conf);
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        return EVENT_LOOP_CONFIG_MAP.get(name);
    }
}

