/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.streams.processors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.storm.streams.Pair;
import org.apache.storm.streams.ProcessorNode;
import org.apache.storm.streams.RefCountedTuple;
import org.apache.storm.streams.StreamUtil;
import org.apache.storm.streams.processors.ProcessorContext;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.Values;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmittingProcessorContext<T>
implements ProcessorContext<T> {
    private static final Logger LOG = LoggerFactory.getLogger(EmittingProcessorContext.class);
    private final ProcessorNode processorNode;
    private final String outputStreamId;
    private final String punctuationStreamId;
    private final OutputCollector collector;
    private final Fields outputFields;
    private final Values punctuation;
    private final List<RefCountedTuple> anchors = new ArrayList<RefCountedTuple>();
    private long eventTimestamp;
    private String timestampField;

    public EmittingProcessorContext(ProcessorNode processorNode, OutputCollector collector, String outputStreamId) {
        this.processorNode = processorNode;
        this.outputStreamId = outputStreamId;
        this.collector = collector;
        this.outputFields = processorNode.getOutputFields();
        this.punctuation = new Values("__punctuation");
        this.punctuationStreamId = StreamUtil.getPunctuationStream(outputStreamId);
    }

    @Override
    public void forward(T input) {
        if ("__punctuation".equals(input)) {
            this.emit(this.punctuation, this.punctuationStreamId);
            this.maybeAck();
        } else if (this.processorNode.emitsPair()) {
            Pair value = (Pair)input;
            this.emit(new Values(value.getFirst(), value.getSecond()), this.outputStreamId);
        } else {
            this.emit(new Values(input), this.outputStreamId);
        }
    }

    @Override
    public void forward(T input, String stream) {
        if (stream.equals(this.outputStreamId)) {
            this.forward(input);
        }
    }

    @Override
    public boolean isWindowed() {
        return this.processorNode.isWindowed();
    }

    @Override
    public Set<String> getWindowedParentStreams() {
        return this.processorNode.getWindowedParentStreams();
    }

    public void setTimestampField(String fieldName) {
        this.timestampField = fieldName;
    }

    public void setAnchor(RefCountedTuple anchor) {
        if (this.processorNode.isWindowed() && this.processorNode.isBatch()) {
            anchor.increment();
            this.anchors.add(anchor);
        } else {
            if (this.anchors.isEmpty()) {
                this.anchors.add(anchor);
            } else {
                this.anchors.set(0, anchor);
            }
            if (StreamUtil.isPunctuation(anchor.tuple().getValue(0))) {
                anchor.increment();
            }
        }
    }

    public void setEventTimestamp(long timestamp) {
        this.eventTimestamp = timestamp;
    }

    private void maybeAck() {
        if (!this.anchors.isEmpty()) {
            for (RefCountedTuple anchor : this.anchors) {
                anchor.decrement();
                if (!anchor.shouldAck()) continue;
                LOG.debug("Acking {} ", (Object)anchor);
                this.collector.ack(anchor.tuple());
                anchor.setAcked();
            }
            this.anchors.clear();
        }
    }

    private Collection<Tuple> tuples(Collection<RefCountedTuple> anchors) {
        return anchors.stream().map(RefCountedTuple::tuple).collect(Collectors.toList());
    }

    private void emit(Values values, String outputStreamId) {
        if (this.timestampField != null) {
            values.add(this.eventTimestamp);
        }
        if (this.anchors.isEmpty()) {
            LOG.debug("Emit un-anchored, outputStreamId: {}, values: {}", (Object)outputStreamId, (Object)values);
            this.collector.emit(outputStreamId, (List<Object>)values);
        } else {
            LOG.debug("Emit, outputStreamId: {}, anchors: {}, values: {}", new Object[]{outputStreamId, this.anchors, values});
            this.collector.emit(outputStreamId, this.tuples(this.anchors), (List<Object>)values);
        }
    }
}

