/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jgrapht.experimental.isomorphism;

import java.util.HashMap;
import java.util.List;
import org.apache.storm.shade.org.jgrapht.Graph;
import org.apache.storm.shade.org.jgrapht.GraphMapping;
import org.apache.storm.shade.org.jgrapht.graph.DefaultGraphMapping;

public class IsomorphismRelation<V, E>
implements GraphMapping<V, E> {
    private List<V> vertexList1;
    private List<V> vertexList2;
    private GraphMapping<V, E> graphMapping = null;
    private Graph<V, E> graph1;
    private Graph<V, E> graph2;

    public IsomorphismRelation(List<V> aGraph1vertexArray, List<V> aGraph2vertexArray, Graph<V, E> g1, Graph<V, E> g2) {
        this.vertexList1 = aGraph1vertexArray;
        this.vertexList2 = aGraph2vertexArray;
        this.graph1 = g1;
        this.graph2 = g2;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("vertexList1: ").append(this.vertexList1.toString());
        sb.append("\tvertexList2: ").append(this.vertexList2.toString());
        return sb.toString();
    }

    @Override
    public V getVertexCorrespondence(V vertex, boolean forward) {
        if (this.graphMapping == null) {
            this.initGraphMapping();
        }
        return this.graphMapping.getVertexCorrespondence(vertex, forward);
    }

    @Override
    public E getEdgeCorrespondence(E edge, boolean forward) {
        if (this.graphMapping == null) {
            this.initGraphMapping();
        }
        return this.graphMapping.getEdgeCorrespondence(edge, forward);
    }

    private void initGraphMapping() {
        int mapSize = this.vertexList1.size();
        HashMap<V, V> g1ToG2 = new HashMap<V, V>(mapSize);
        HashMap<V, V> g2ToG1 = new HashMap<V, V>(mapSize);
        for (int i = 0; i < mapSize; ++i) {
            V source = this.vertexList1.get(i);
            V target = this.vertexList2.get(i);
            g1ToG2.put(source, target);
            g2ToG1.put(target, source);
        }
        this.graphMapping = new DefaultGraphMapping(g1ToG2, g2ToG1, this.graph1, this.graph2);
    }
}

