/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.windowing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.storm.trident.windowing.WindowsStore;

public class InMemoryWindowsStore
implements WindowsStore,
Serializable {
    private final ConcurrentHashMap<String, Object> store = new ConcurrentHashMap();
    private int maxSize;
    private AtomicInteger currentSize;
    private WindowsStore backingStore;

    public InMemoryWindowsStore() {
    }

    public InMemoryWindowsStore(int maxSize, WindowsStore backingStore) {
        this.maxSize = maxSize;
        this.currentSize = new AtomicInteger();
        this.backingStore = backingStore;
    }

    @Override
    public Object get(String key) {
        Object value = this.store.get(key);
        if (value == null && this.backingStore != null) {
            value = this.backingStore.get(key);
        }
        return value;
    }

    @Override
    public Iterable<Object> get(List<String> keys) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (String key : keys) {
            values.add(this.get(key));
        }
        return values;
    }

    @Override
    public Iterable<String> getAllKeys() {
        if (this.backingStore != null) {
            return this.backingStore.getAllKeys();
        }
        final Enumeration<String> storeEnumeration = this.store.keys();
        final Iterator<String> resultIterator = new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return storeEnumeration.hasMoreElements();
            }

            @Override
            public String next() {
                return (String)storeEnumeration.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove operation is not supported as it is immutable.");
            }
        };
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return resultIterator;
            }
        };
    }

    @Override
    public void put(String key, Object value) {
        this.put0(key, value);
        if (this.backingStore != null) {
            this.backingStore.put(key, value);
        }
    }

    private void put0(String key, Object value) {
        if (!this.canAdd()) {
            return;
        }
        this.store.put(key, value);
        this.incrementCurrentSize();
    }

    private void incrementCurrentSize() {
        if (this.backingStore != null) {
            this.currentSize.incrementAndGet();
        }
    }

    private boolean canAdd() {
        return this.backingStore == null || this.currentSize.get() < this.maxSize;
    }

    @Override
    public void putAll(Collection<WindowsStore.Entry> entries) {
        for (WindowsStore.Entry entry : entries) {
            this.put0(entry.key, entry.value);
        }
        if (this.backingStore != null) {
            this.backingStore.putAll(entries);
        }
    }

    @Override
    public void remove(String key) {
        this.remove0(key);
        if (this.backingStore != null) {
            this.backingStore.remove(key);
        }
    }

    private void remove0(String key) {
        Object oldValue = this.store.remove(key);
        if (oldValue != null) {
            this.decrementSize();
            if (this.backingStore != null) {
                this.backingStore.remove(key);
            }
        }
    }

    private void decrementSize() {
        if (this.backingStore != null) {
            this.currentSize.decrementAndGet();
        }
    }

    @Override
    public void removeAll(Collection<String> keys) {
        for (String key : keys) {
            this.remove0(key);
        }
        if (this.backingStore != null) {
            this.backingStore.removeAll(keys);
        }
    }

    @Override
    public void shutdown() {
        this.store.clear();
        if (this.backingStore != null) {
            this.backingStore.shutdown();
        }
    }

    public String toString() {
        return "InMemoryWindowsStore{ store:size = " + this.store.size() + " backingStore = " + String.valueOf(this.backingStore) + "}";
    }
}

