/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.partition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.grouping.CustomStreamGrouping;
import org.apache.storm.task.WorkerTopologyContext;

public class IdentityGrouping
implements CustomStreamGrouping {
    final Map<Integer, List<Integer>> precomputed = new HashMap<Integer, List<Integer>>();

    @Override
    public void prepare(WorkerTopologyContext context, GlobalStreamId stream, List<Integer> tasks) {
        ArrayList<Integer> sourceTasks = new ArrayList<Integer>(context.getComponentTasks(stream.get_componentId()));
        Collections.sort(sourceTasks);
        if (sourceTasks.size() != tasks.size()) {
            throw new RuntimeException("Can only do an identity grouping when source and target have same number of tasks");
        }
        tasks = new ArrayList<Integer>(tasks);
        Collections.sort(tasks);
        for (int i = 0; i < sourceTasks.size(); ++i) {
            int s = (Integer)sourceTasks.get(i);
            int t = tasks.get(i);
            this.precomputed.put(s, Arrays.asList(t));
        }
    }

    @Override
    public List<Integer> chooseTasks(int task, List<Object> values) {
        List<Integer> ret = this.precomputed.get(task);
        if (ret == null) {
            throw new RuntimeException("Tuple emitted by task that's not part of this component. Should be impossible");
        }
        return ret;
    }
}

