/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.lang.reflect.Array;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.apache.sis.math.NumberType;
import org.apache.sis.measure.Range;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.DefaultParameterValue;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.system.Semaphores;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.ReferenceIdentifier;

final class Verifier {
    private final short errorKey;
    private final boolean internal;
    private final Object[] arguments;

    private Verifier(boolean internal, short errorKey, Object ... arguments) {
        this.errorKey = errorKey;
        this.internal = internal;
        this.arguments = arguments;
    }

    static <T> T ensureValidValue(ParameterDescriptor<T> descriptor, Object value, Unit<?> unit) throws InvalidParameterValueException {
        Unit def;
        Class expectedClass = descriptor.getValueClass();
        UnitConverter converter = null;
        Object convertedValue = value;
        if (unit != null && (def = descriptor.getUnit()) != null && !unit.equals((Object)def)) {
            short expectedID = Verifier.getUnitMessageID(def);
            if (Verifier.getUnitMessageID(unit) != expectedID) {
                throw new InvalidParameterValueException(Errors.format((short)expectedID, unit), Verifier.getDisplayName(descriptor), value);
            }
            if (value != null) {
                if (!expectedClass.isInstance(value)) {
                    String name = Verifier.getDisplayName(descriptor);
                    throw new InvalidParameterValueException(Resources.format((short)24, name, expectedClass, value.getClass()), name, value);
                }
                try {
                    converter = unit.getConverterToAny(def);
                }
                catch (IncommensurableException e) {
                    throw new IllegalArgumentException(Errors.format((short)84, unit, (Object)def), e);
                }
                Class<?> componentType = expectedClass.getComponentType();
                int i = -1;
                try {
                    if (componentType == null) {
                        Number n = converter.convert((Number)value);
                        convertedValue = NumberType.forNumberClass((Class)expectedClass).cast(n);
                    } else {
                        int length = Array.getLength(value);
                        if (length != 0) {
                            Class<Number> numberType = NumberType.primitiveToWrapper(componentType).asSubclass(Number.class);
                            convertedValue = Array.newInstance(componentType, length);
                            for (i = 0; i < length; ++i) {
                                Number n = (Number)Array.get(value, i);
                                n = converter.convert(n);
                                n = NumberType.forNumberClass(numberType).cast(n);
                                Array.set(convertedValue, i, n);
                            }
                        }
                    }
                }
                catch (ClassCastException | IllegalArgumentException cause) {
                    String name = Verifier.getDisplayName(descriptor);
                    if (i >= 0) {
                        name = Strings.toIndexed((String)name, (int)i);
                    }
                    InvalidParameterValueException e = new InvalidParameterValueException(cause.getLocalizedMessage(), name, value);
                    e.initCause((Throwable)cause);
                    throw e;
                }
            }
        }
        if (convertedValue != null) {
            Set validValues = descriptor.getValidValues();
            Verifier error = descriptor instanceof DefaultParameterDescriptor ? Verifier.ensureValidValue(expectedClass, validValues, ((DefaultParameterDescriptor)descriptor).getValueDomain(), convertedValue) : Verifier.ensureValidValue(expectedClass, validValues, descriptor.getMinimumValue(), descriptor.getMaximumValue(), convertedValue);
            if (error != null) {
                error.convertRange(converter);
                String name = Verifier.getDisplayName(descriptor);
                String message = error.message(null, name, value);
                if (Semaphores.SUSPEND_PARAMETER_CHECK.get()) {
                    Logging.completeAndLog((Logger)DefaultParameterValue.LOGGER, DefaultParameterValue.class, (String)"setValue", (LogRecord)new LogRecord(Level.WARNING, message));
                } else {
                    throw new InvalidParameterValueException(message, name, value);
                }
            }
        }
        return expectedClass.cast(convertedValue);
    }

    static <T> Verifier ensureValidValue(Class<T> valueClass, Set<T> validValues, Range<?> valueDomain, Object convertedValue) {
        Verifier verifier = Verifier.ensureValidValue(valueClass, validValues, null, null, convertedValue);
        if (verifier == null && valueDomain != null) {
            boolean isArray = valueClass.isArray();
            assert (valueDomain.getElementType() == (isArray ? NumberType.primitiveToWrapper(valueClass.getComponentType()) : valueClass)) : valueDomain;
            int length = isArray ? Array.getLength(convertedValue) : 1;
            for (int i = 0; i < length; ++i) {
                Object[] arguments;
                short errorKey;
                Object value;
                Object object = value = isArray ? Array.get(convertedValue, i) : convertedValue;
                if (valueDomain.contains((Comparable)value)) continue;
                Comparable minValue = valueDomain.getMinValue();
                if (minValue instanceof Number && ((Number)((Object)minValue)).doubleValue() == 0.0 && !valueDomain.isMinIncluded() && value instanceof Number && ((Number)value).doubleValue() <= 0.0) {
                    errorKey = 203;
                    arguments = new Object[2];
                } else {
                    errorKey = 204;
                    arguments = new Object[4];
                    arguments[1] = minValue;
                    arguments[2] = valueDomain.getMaxValue();
                }
                if (isArray) {
                    arguments[0] = i;
                }
                arguments[arguments.length - 1] = value;
                return new Verifier(false, errorKey, arguments);
            }
        }
        return verifier;
    }

    private static <T> Verifier ensureValidValue(Class<T> valueClass, Set<T> validValues, Comparable<T> minimum, Comparable<T> maximum, Object convertedValue) {
        if (!valueClass.isInstance(convertedValue)) {
            return new Verifier(true, 24, null, valueClass, convertedValue.getClass());
        }
        if (validValues != null && !validValues.contains(convertedValue)) {
            return new Verifier(true, 25, null, convertedValue);
        }
        if (minimum != null && minimum.compareTo(convertedValue) > 0 || maximum != null && maximum.compareTo(convertedValue) < 0) {
            return new Verifier(false, 204, null, minimum, maximum, convertedValue);
        }
        return null;
    }

    private void convertRange(UnitConverter converter) {
        if (converter != null && !this.internal && this.errorKey == 204) {
            converter = converter.inverse();
            for (int i = 1; i <= 2; ++i) {
                Object value = this.arguments[i];
                if (!(value instanceof Number)) continue;
                this.arguments[i] = converter.convert(((Number)value).doubleValue());
            }
        }
    }

    String message(Map<?, ?> properties, String name, Object value) {
        Resources resources;
        Object index = this.arguments[0];
        if (index != null) {
            name = Strings.bracket((String)name, (Object)index);
            value = Array.get(value, (Integer)index);
        }
        this.arguments[0] = name;
        if (this.internal) {
            resources = Resources.forProperties(properties);
            switch (this.errorKey) {
                case 25: {
                    this.arguments[1] = value;
                }
            }
        } else {
            resources = Errors.forProperties(properties);
            switch (this.errorKey) {
                case 204: {
                    if (this.arguments[1] == null) {
                        this.arguments[1] = "\u2212\u221e";
                    }
                    if (this.arguments[2] == null) {
                        this.arguments[2] = "\u221e";
                    }
                    this.arguments[3] = value;
                    break;
                }
                case 203: {
                    this.arguments[1] = value;
                }
            }
        }
        return resources.getString(this.errorKey, this.arguments);
    }

    static String getDisplayName(GeneralParameterDescriptor descriptor) {
        String code;
        ReferenceIdentifier name;
        if (descriptor != null && (name = descriptor.getName()) != null && (code = name.getCode()) != null) {
            return code;
        }
        return Vocabulary.format((short)208);
    }

    static short getUnitMessageID(Unit<?> unit) {
        if (Units.isLinear(unit)) {
            return 130;
        }
        if (Units.isAngular(unit)) {
            return 126;
        }
        if (Units.isTemporal(unit)) {
            return 133;
        }
        if (Units.isScale(unit)) {
            return 132;
        }
        return 83;
    }
}

