/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.metrics;

import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.core.spi.observability.HttpRequest;
import io.vertx.core.spi.observability.HttpResponse;
import org.apache.servicecomb.foundation.vertx.metrics.metric.DefaultRequestMetric;
import org.apache.servicecomb.foundation.vertx.metrics.metric.DefaultServerEndpointMetric;
import org.apache.servicecomb.foundation.vertx.metrics.metric.DefaultTcpSocketMetric;

public class DefaultHttpServerMetrics
implements HttpServerMetrics<DefaultRequestMetric, Object, DefaultTcpSocketMetric> {
    private final DefaultServerEndpointMetric endpointMetric;

    public DefaultHttpServerMetrics(DefaultServerEndpointMetric endpointMetric) {
        this.endpointMetric = endpointMetric;
    }

    public DefaultServerEndpointMetric getEndpointMetric() {
        return this.endpointMetric;
    }

    public DefaultRequestMetric requestBegin(DefaultTcpSocketMetric socketMetric, HttpRequest request) {
        DefaultRequestMetric requestMetric = new DefaultRequestMetric(socketMetric.getEndpointMetric());
        requestMetric.requestBegin();
        return requestMetric;
    }

    public void requestEnd(DefaultRequestMetric requestMetric, HttpRequest request, long bytesRead) {
        requestMetric.requestEnd();
    }

    public void responseBegin(DefaultRequestMetric requestMetric, HttpResponse response) {
        requestMetric.responseBegin();
    }

    public void responseEnd(DefaultRequestMetric requestMetric, HttpResponse response, long bytesWritten) {
        requestMetric.responseEnd();
    }

    public DefaultTcpSocketMetric connected(SocketAddress remoteAddress, String remoteName) {
        DefaultTcpSocketMetric socketMetric = new DefaultTcpSocketMetric(this.endpointMetric);
        socketMetric.onConnect();
        return socketMetric;
    }

    public void disconnected(DefaultTcpSocketMetric socketMetric, SocketAddress remoteAddress) {
        socketMetric.onDisconnect();
    }

    public void bytesRead(DefaultTcpSocketMetric socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        socketMetric.getEndpointMetric().addBytesRead(numberOfBytes);
    }

    public void bytesWritten(DefaultTcpSocketMetric socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        socketMetric.getEndpointMetric().addBytesWritten(numberOfBytes);
    }
}

